/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.configuration.impl;

import java.io.IOException;
import java.util.HashSet;
import org.camunda.bpm.engine.spring.SpringProcessEngineConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.CamundaDeploymentConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.impl.AbstractCamundaConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourceArrayPropertyEditor;

public class DefaultDeploymentConfiguration
extends AbstractCamundaConfiguration
implements CamundaDeploymentConfiguration {
    private final Logger logger = LoggerFactory.getLogger(DefaultDeploymentConfiguration.class);

    @Override
    public void accept(SpringProcessEngineConfiguration configuration) {
        if (this.camundaBpmProperties.isAutoDeploymentEnabled()) {
            configuration.setDeploymentResources(this.getDeploymentResources());
        }
    }

    protected Resource[] getDeploymentResources() {
        HashSet<Resource> resources = new HashSet<Resource>();
        ResourceArrayPropertyEditor resolver = new ResourceArrayPropertyEditor();
        try {
            Object[] resourcePattern = this.camundaBpmProperties.getDeploymentResourcePattern();
            this.logger.debug("resolving deployment resources for pattern {}", resourcePattern);
            resolver.setValue((Object)resourcePattern);
            for (Resource resource : (Resource[])resolver.getValue()) {
                if (!this.isFile(resource)) continue;
                resources.add(resource);
            }
            this.logger.debug("resolved {}", resources);
        }
        catch (RuntimeException e) {
            this.logger.error("unable to resolve resources", (Throwable)e);
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    private boolean isFile(Resource resource) {
        try {
            return !resource.getFile().isDirectory();
        }
        catch (IOException e) {
            return false;
        }
    }
}

