/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.spring.boot.starter.configuration.impl;

import java.util.List;
import org.camunda.bpm.engine.impl.jobexecutor.CallerRunsRejectedJobsHandler;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandler;
import org.camunda.bpm.engine.impl.jobexecutor.RejectedJobsHandler;
import org.camunda.bpm.engine.spring.SpringProcessEngineConfiguration;
import org.camunda.bpm.engine.spring.components.jobexecutor.SpringJobExecutor;
import org.camunda.bpm.spring.boot.starter.configuration.CamundaJobConfiguration;
import org.camunda.bpm.spring.boot.starter.configuration.impl.AbstractCamundaConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class DefaultJobConfiguration
extends AbstractCamundaConfiguration
implements CamundaJobConfiguration {
    @Autowired
    protected JobExecutor jobExecutor;
    @Autowired(required=false)
    protected List<JobHandler> customJobHandlers;
    CamundaJobConfiguration configureJobExecutor = new CamundaJobConfiguration(){

        @Override
        public void accept(SpringProcessEngineConfiguration configuration) {
            configuration.setJobExecutorActivate(false);
            configuration.setJobExecutorDeploymentAware(DefaultJobConfiguration.this.camundaBpmProperties.getJobExecution().isDeploymentAware());
            configuration.setJobExecutor(DefaultJobConfiguration.this.jobExecutor);
        }
    };
    CamundaJobConfiguration registerCustomJobHandlers = new CamundaJobConfiguration(){

        @Override
        public void accept(SpringProcessEngineConfiguration configuration) {
            configuration.setCustomJobHandlers(AbstractCamundaConfiguration.join(configuration.getCustomJobHandlers(), DefaultJobConfiguration.this.customJobHandlers));
            for (JobHandler jobHandler : configuration.getCustomJobHandlers()) {
                DefaultJobConfiguration.this.logger.info("Register Custom JobHandler: '{}'", (Object)jobHandler.getType());
            }
        }
    };

    @Override
    public void accept(SpringProcessEngineConfiguration configuration) {
        this.configureJobExecutor.accept(configuration);
        this.registerCustomJobHandlers.accept(configuration);
    }

    public static class JobConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={TaskExecutor.class})
        @ConditionalOnProperty(prefix="camunda.bpm.job-execution", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public static TaskExecutor taskExecutor() {
            return new ThreadPoolTaskExecutor();
        }

        @Bean
        @ConditionalOnMissingBean(value={JobExecutor.class})
        @ConditionalOnProperty(prefix="camunda.bpm.job-execution", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public static JobExecutor jobExecutor(TaskExecutor taskExecutor) {
            SpringJobExecutor springJobExecutor = new SpringJobExecutor();
            springJobExecutor.setTaskExecutor(taskExecutor);
            springJobExecutor.setRejectedJobsHandler((RejectedJobsHandler)new CallerRunsRejectedJobsHandler());
            return springJobExecutor;
        }
    }
}

