/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.aot.generate;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.IntFunction;
import keycloakjar.org.springframework.core.ResolvableType;
import keycloakjar.org.springframework.javapoet.ClassName;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.ClassUtils;

public final class AccessControl {
    private final Class<?> target;
    private final Visibility visibility;

    AccessControl(Class<?> target, Visibility visibility) {
        this.target = target;
        this.visibility = visibility;
    }

    public static AccessControl forMember(Member member) {
        return new AccessControl(member.getDeclaringClass(), Visibility.forMember(member));
    }

    public static AccessControl forResolvableType(ResolvableType resolvableType) {
        return new AccessControl(resolvableType.toClass(), Visibility.forResolvableType(resolvableType));
    }

    public static AccessControl forClass(Class<?> type) {
        return new AccessControl(type, Visibility.forClass(type));
    }

    public static AccessControl lowest(AccessControl ... candidates) {
        int index = Visibility.lowestIndex((Visibility[])Arrays.stream(candidates).map(AccessControl::getVisibility).toArray(Visibility[]::new));
        return candidates[index];
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public boolean isPublic() {
        return this.visibility == Visibility.PUBLIC;
    }

    public boolean isAccessibleFrom(ClassName type) {
        if (this.visibility == Visibility.PRIVATE) {
            return false;
        }
        if (this.visibility == Visibility.PUBLIC) {
            return true;
        }
        return this.target.getPackageName().equals(type.packageName());
    }

    public static enum Visibility {
        PUBLIC,
        PROTECTED,
        PACKAGE_PRIVATE,
        PRIVATE;


        private static Visibility forMember(Member member) {
            Assert.notNull((Object)member, "'member' must not be null");
            Visibility visibility = Visibility.forModifiers(member.getModifiers());
            Visibility declaringClassVisibility = Visibility.forClass(member.getDeclaringClass());
            visibility = Visibility.lowest(visibility, declaringClassVisibility);
            if (visibility != PRIVATE) {
                if (member instanceof Field) {
                    Field field = (Field)member;
                    Visibility fieldVisibility = Visibility.forResolvableType(ResolvableType.forField(field));
                    return Visibility.lowest(visibility, fieldVisibility);
                }
                if (member instanceof Constructor) {
                    Constructor constructor = (Constructor)member;
                    Visibility parameterVisibility = Visibility.forParameterTypes(constructor, i -> ResolvableType.forConstructorParameter(constructor, i));
                    return Visibility.lowest(visibility, parameterVisibility);
                }
                if (member instanceof Method) {
                    Method method = (Method)member;
                    Visibility parameterVisibility = Visibility.forParameterTypes(method, i -> ResolvableType.forMethodParameter(method, i));
                    Visibility returnTypeVisibility = Visibility.forResolvableType(ResolvableType.forMethodReturnType(method));
                    return Visibility.lowest(visibility, parameterVisibility, returnTypeVisibility);
                }
            }
            return PRIVATE;
        }

        private static Visibility forResolvableType(ResolvableType resolvableType) {
            return Visibility.forResolvableType(resolvableType, new HashSet<ResolvableType>());
        }

        private static Visibility forResolvableType(ResolvableType resolvableType, Set<ResolvableType> seen) {
            if (!seen.add(resolvableType)) {
                return PUBLIC;
            }
            Class<?> userClass = ClassUtils.getUserClass(resolvableType.toClass());
            ResolvableType userType = resolvableType.as(userClass);
            Visibility visibility = Visibility.forClass(userType.toClass());
            for (ResolvableType generic : userType.getGenerics()) {
                visibility = Visibility.lowest(visibility, Visibility.forResolvableType(generic, seen));
            }
            return visibility;
        }

        private static Visibility forParameterTypes(Executable executable, IntFunction<ResolvableType> resolvableTypeFactory) {
            Visibility visibility = PUBLIC;
            Class<?>[] parameterTypes = executable.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                ResolvableType type = resolvableTypeFactory.apply(i);
                visibility = Visibility.lowest(visibility, Visibility.forResolvableType(type));
            }
            return visibility;
        }

        private static Visibility forClass(Class<?> clazz) {
            Class<?> enclosingClass;
            clazz = ClassUtils.getUserClass(clazz);
            Visibility visibility = Visibility.forModifiers(clazz.getModifiers());
            if (clazz.isArray()) {
                visibility = Visibility.lowest(visibility, Visibility.forClass(clazz.getComponentType()));
            }
            if ((enclosingClass = clazz.getEnclosingClass()) != null) {
                visibility = Visibility.lowest(visibility, Visibility.forClass(clazz.getEnclosingClass()));
            }
            return visibility;
        }

        private static Visibility forModifiers(int modifiers) {
            if (Modifier.isPublic(modifiers)) {
                return PUBLIC;
            }
            if (Modifier.isProtected(modifiers)) {
                return PROTECTED;
            }
            if (Modifier.isPrivate(modifiers)) {
                return PRIVATE;
            }
            return PACKAGE_PRIVATE;
        }

        static Visibility lowest(Visibility ... candidates) {
            Visibility visibility = PUBLIC;
            for (Visibility candidate : candidates) {
                if (candidate.ordinal() <= visibility.ordinal()) continue;
                visibility = candidate;
            }
            return visibility;
        }

        static int lowestIndex(Visibility ... candidates) {
            Visibility visibility = PUBLIC;
            int index = 0;
            for (int i = 0; i < candidates.length; ++i) {
                Visibility candidate = candidates[i];
                if (candidate.ordinal() <= visibility.ordinal()) continue;
                visibility = candidate;
                index = i;
            }
            return index;
        }
    }
}

