/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.aot.hint;

import keycloakjar.org.springframework.aot.hint.AbstractTypeReference;
import keycloakjar.org.springframework.aot.hint.TypeReference;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;

final class ReflectionTypeReference
extends AbstractTypeReference {
    private final Class<?> type;

    private ReflectionTypeReference(Class<?> type) {
        super(type.getPackageName(), type.getSimpleName(), ReflectionTypeReference.getEnclosingClass(type));
        this.type = type;
    }

    @Nullable
    private static TypeReference getEnclosingClass(Class<?> type) {
        Class<?> candidate = type.isArray() ? type.getComponentType().getEnclosingClass() : type.getEnclosingClass();
        return candidate != null ? new ReflectionTypeReference(candidate) : null;
    }

    static ReflectionTypeReference of(Class<?> type) {
        Assert.notNull(type, "'type' must not be null");
        Assert.notNull((Object)type.getCanonicalName(), "'type.getCanonicalName()' must not be null");
        return new ReflectionTypeReference(type);
    }

    @Override
    public String getCanonicalName() {
        return this.type.getCanonicalName();
    }

    @Override
    protected boolean isPrimitive() {
        return this.type.isPrimitive() || this.type.isArray() && this.type.getComponentType().isPrimitive();
    }
}

