/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.aot.hint.support;

import java.util.List;
import java.util.Map;
import keycloakjar.org.apache.commons.logging.Log;
import keycloakjar.org.apache.commons.logging.LogFactory;
import keycloakjar.org.springframework.aot.hint.MemberCategory;
import keycloakjar.org.springframework.aot.hint.RuntimeHints;
import keycloakjar.org.springframework.aot.hint.RuntimeHintsRegistrar;
import keycloakjar.org.springframework.core.io.support.SpringFactoriesLoader;
import keycloakjar.org.springframework.core.log.LogMessage;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.ClassUtils;

class SpringFactoriesLoaderRuntimeHints
implements RuntimeHintsRegistrar {
    private static final List<String> RESOURCE_LOCATIONS = List.of("META-INF/spring.factories");
    private static final Log logger = LogFactory.getLog(SpringFactoriesLoaderRuntimeHints.class);

    SpringFactoriesLoaderRuntimeHints() {
    }

    @Override
    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        for (String resourceLocation : RESOURCE_LOCATIONS) {
            this.registerHints(hints, classLoader, resourceLocation);
        }
    }

    private void registerHints(RuntimeHints hints, ClassLoader classLoader, String resourceLocation) {
        hints.resources().registerPattern(resourceLocation);
        Map<String, List<String>> factories = ExtendedSpringFactoriesLoader.accessLoadFactoriesResource(classLoader, resourceLocation);
        factories.forEach((factoryClassName, implementationClassNames) -> this.registerHints(hints, classLoader, (String)factoryClassName, (List<String>)implementationClassNames));
    }

    private void registerHints(RuntimeHints hints, ClassLoader classLoader, String factoryClassName, List<String> implementationClassNames) {
        Class<?> factoryClass = this.resolveClassName(classLoader, factoryClassName);
        if (factoryClass == null) {
            if (logger.isTraceEnabled()) {
                logger.trace(LogMessage.format("Skipping factories for [%s]", (Object)factoryClassName));
            }
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace(LogMessage.format("Processing factories for [%s]", (Object)factoryClassName));
        }
        hints.reflection().registerType(factoryClass, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS);
        for (String implementationClassName : implementationClassNames) {
            Class<?> implementationType = this.resolveClassName(classLoader, implementationClassName);
            if (logger.isTraceEnabled()) {
                logger.trace(LogMessage.format("%s factory type [%s] and implementation [%s]", (Object)(implementationType != null ? "Processing" : "Skipping"), (Object)factoryClassName, (Object)implementationClassName));
            }
            if (implementationType == null) continue;
            hints.reflection().registerType(implementationType, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS);
        }
    }

    @Nullable
    private Class<?> resolveClassName(ClassLoader classLoader, String factoryClassName) {
        try {
            Class<?> clazz = ClassUtils.resolveClassName(factoryClassName, classLoader);
            clazz.getDeclaredConstructors();
            return clazz;
        }
        catch (Throwable ex) {
            return null;
        }
    }

    private static class ExtendedSpringFactoriesLoader
    extends SpringFactoriesLoader {
        ExtendedSpringFactoriesLoader(@Nullable ClassLoader classLoader, Map<String, List<String>> factories) {
            super(classLoader, factories);
        }

        static Map<String, List<String>> accessLoadFactoriesResource(ClassLoader classLoader, String resourceLocation) {
            return SpringFactoriesLoader.loadFactoriesResource(classLoader, resourceLocation);
        }
    }
}

