/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.aot.nativex;

import java.util.LinkedHashMap;
import java.util.Map;
import keycloakjar.org.springframework.aot.hint.ConditionalHint;
import keycloakjar.org.springframework.aot.hint.JavaSerializationHint;
import keycloakjar.org.springframework.aot.hint.SerializationHints;
import keycloakjar.org.springframework.aot.hint.TypeReference;
import keycloakjar.org.springframework.aot.nativex.BasicJsonWriter;

class SerializationHintsWriter {
    public static final SerializationHintsWriter INSTANCE = new SerializationHintsWriter();

    SerializationHintsWriter() {
    }

    public void write(BasicJsonWriter writer, SerializationHints hints) {
        writer.writeArray(hints.javaSerializationHints().map(this::toAttributes).toList());
    }

    private Map<String, Object> toAttributes(JavaSerializationHint serializationHint) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        this.handleCondition(attributes, serializationHint);
        attributes.put("name", serializationHint.getType());
        return attributes;
    }

    private void handleCondition(Map<String, Object> attributes, ConditionalHint hint) {
        if (hint.getReachableType() != null) {
            LinkedHashMap<String, TypeReference> conditionAttributes = new LinkedHashMap<String, TypeReference>();
            conditionAttributes.put("typeReachable", hint.getReachableType());
            attributes.put("condition", conditionAttributes);
        }
    }
}

