/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;
import keycloakjar.org.apache.hc.client5.http.classic.HttpClient;
import keycloakjar.org.apache.hc.core5.function.Supplier;
import keycloakjar.org.apache.hc.core5.http.ClassicHttpRequest;
import keycloakjar.org.apache.hc.core5.http.ClassicHttpResponse;
import keycloakjar.org.apache.hc.core5.http.Header;
import keycloakjar.org.apache.hc.core5.http.HttpEntity;
import keycloakjar.org.apache.hc.core5.http.HttpResponse;
import keycloakjar.org.apache.hc.core5.http.protocol.HttpContext;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpMethod;
import keycloakjar.org.springframework.http.StreamingHttpOutputMessage;
import keycloakjar.org.springframework.http.client.AbstractClientHttpRequest;
import keycloakjar.org.springframework.http.client.ClientHttpResponse;
import keycloakjar.org.springframework.http.client.HttpComponentsClientHttpRequest;
import keycloakjar.org.springframework.http.client.HttpComponentsClientHttpResponse;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;

final class HttpComponentsStreamingClientHttpRequest
extends AbstractClientHttpRequest
implements StreamingHttpOutputMessage {
    private final HttpClient httpClient;
    private final ClassicHttpRequest httpRequest;
    private final HttpContext httpContext;
    @Nullable
    private StreamingHttpOutputMessage.Body body;

    HttpComponentsStreamingClientHttpRequest(HttpClient client, ClassicHttpRequest request, HttpContext context) {
        this.httpClient = client;
        this.httpRequest = request;
        this.httpContext = context;
    }

    @Override
    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.httpRequest.getMethod());
    }

    @Override
    public URI getURI() {
        try {
            return this.httpRequest.getUri();
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    @Override
    public void setBody(StreamingHttpOutputMessage.Body body) {
        this.assertNotExecuted();
        this.body = body;
    }

    @Override
    protected OutputStream getBodyInternal(HttpHeaders headers) {
        throw new UnsupportedOperationException("getBody not supported");
    }

    @Override
    protected ClientHttpResponse executeInternal(HttpHeaders headers) throws IOException {
        HttpComponentsClientHttpRequest.addHeaders(this.httpRequest, headers);
        if (this.body != null) {
            StreamingHttpEntity requestEntity = new StreamingHttpEntity(this.getHeaders(), this.body);
            this.httpRequest.setEntity(requestEntity);
        }
        HttpResponse httpResponse = this.httpClient.execute(this.httpRequest, this.httpContext);
        Assert.isInstanceOf(ClassicHttpResponse.class, (Object)httpResponse, "HttpResponse not an instance of ClassicHttpResponse");
        return new HttpComponentsClientHttpResponse((ClassicHttpResponse)httpResponse);
    }

    private static class StreamingHttpEntity
    implements HttpEntity {
        private final HttpHeaders headers;
        private final StreamingHttpOutputMessage.Body body;

        public StreamingHttpEntity(HttpHeaders headers, StreamingHttpOutputMessage.Body body) {
            this.headers = headers;
            this.body = body;
        }

        @Override
        public boolean isRepeatable() {
            return false;
        }

        @Override
        public boolean isChunked() {
            return false;
        }

        @Override
        public long getContentLength() {
            return this.headers.getContentLength();
        }

        @Override
        @Nullable
        public String getContentType() {
            return this.headers.getFirst("Content-Type");
        }

        @Override
        @Nullable
        public String getContentEncoding() {
            return this.headers.getFirst("Content-Encoding");
        }

        @Override
        public InputStream getContent() throws IOException, IllegalStateException {
            throw new IllegalStateException("No content available");
        }

        @Override
        public void writeTo(OutputStream outputStream) throws IOException {
            this.body.writeTo(outputStream);
        }

        @Override
        public boolean isStreaming() {
            return true;
        }

        @Override
        @Nullable
        public Supplier<List<? extends Header>> getTrailers() {
            return null;
        }

        @Override
        @Nullable
        public Set<String> getTrailerNames() {
            return null;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

