/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.client.observation;

import java.io.IOException;
import java.util.regex.Pattern;
import keycloakjar.io.micrometer.common.KeyValue;
import keycloakjar.io.micrometer.common.KeyValues;
import keycloakjar.org.springframework.http.HttpStatus;
import keycloakjar.org.springframework.http.HttpStatusCode;
import keycloakjar.org.springframework.http.client.ClientHttpRequest;
import keycloakjar.org.springframework.http.client.ClientHttpResponse;
import keycloakjar.org.springframework.http.client.observation.ClientHttpObservationDocumentation;
import keycloakjar.org.springframework.http.client.observation.ClientRequestObservationContext;
import keycloakjar.org.springframework.http.client.observation.ClientRequestObservationConvention;
import keycloakjar.org.springframework.util.StringUtils;

public class DefaultClientRequestObservationConvention
implements ClientRequestObservationConvention {
    private static final String DEFAULT_NAME = "http.client.requests";
    private static final Pattern PATTERN_BEFORE_PATH = Pattern.compile("^https?://[^/]+/");
    private static final KeyValue URI_NONE = KeyValue.of(ClientHttpObservationDocumentation.LowCardinalityKeyNames.URI, "none");
    private static final KeyValue METHOD_NONE = KeyValue.of(ClientHttpObservationDocumentation.LowCardinalityKeyNames.METHOD, "none");
    private static final KeyValue STATUS_IO_ERROR = KeyValue.of(ClientHttpObservationDocumentation.LowCardinalityKeyNames.STATUS, "IO_ERROR");
    private static final KeyValue STATUS_CLIENT_ERROR = KeyValue.of(ClientHttpObservationDocumentation.LowCardinalityKeyNames.STATUS, "CLIENT_ERROR");
    private static final KeyValue HTTP_OUTCOME_SUCCESS = KeyValue.of(ClientHttpObservationDocumentation.LowCardinalityKeyNames.OUTCOME, "SUCCESS");
    private static final KeyValue HTTP_OUTCOME_UNKNOWN = KeyValue.of(ClientHttpObservationDocumentation.LowCardinalityKeyNames.OUTCOME, "UNKNOWN");
    private static final KeyValue CLIENT_NAME_NONE = KeyValue.of(ClientHttpObservationDocumentation.LowCardinalityKeyNames.CLIENT_NAME, "none");
    private static final KeyValue EXCEPTION_NONE = KeyValue.of(ClientHttpObservationDocumentation.LowCardinalityKeyNames.EXCEPTION, "none");
    private static final KeyValue HTTP_URL_NONE = KeyValue.of(ClientHttpObservationDocumentation.HighCardinalityKeyNames.HTTP_URL, "none");
    private final String name;

    public DefaultClientRequestObservationConvention() {
        this(DEFAULT_NAME);
    }

    public DefaultClientRequestObservationConvention(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getContextualName(ClientRequestObservationContext context) {
        return "http " + ((ClientHttpRequest)context.getCarrier()).getMethod().name().toLowerCase();
    }

    @Override
    public KeyValues getLowCardinalityKeyValues(ClientRequestObservationContext context) {
        return KeyValues.of(this.clientName(context), this.exception(context), this.method(context), this.outcome(context), this.status(context), this.uri(context));
    }

    protected KeyValue uri(ClientRequestObservationContext context) {
        if (context.getUriTemplate() != null) {
            return KeyValue.of(ClientHttpObservationDocumentation.LowCardinalityKeyNames.URI, DefaultClientRequestObservationConvention.extractPath(context.getUriTemplate()));
        }
        return URI_NONE;
    }

    private static String extractPath(String uriTemplate) {
        String path = PATTERN_BEFORE_PATH.matcher(uriTemplate).replaceFirst("");
        return path.startsWith("/") ? path : "/" + path;
    }

    protected KeyValue method(ClientRequestObservationContext context) {
        if (context.getCarrier() != null) {
            return KeyValue.of(ClientHttpObservationDocumentation.LowCardinalityKeyNames.METHOD, ((ClientHttpRequest)context.getCarrier()).getMethod().name());
        }
        return METHOD_NONE;
    }

    protected KeyValue status(ClientRequestObservationContext context) {
        ClientHttpResponse response = (ClientHttpResponse)context.getResponse();
        if (response == null) {
            return STATUS_CLIENT_ERROR;
        }
        try {
            return KeyValue.of(ClientHttpObservationDocumentation.LowCardinalityKeyNames.STATUS, String.valueOf(response.getStatusCode().value()));
        }
        catch (IOException ex) {
            return STATUS_IO_ERROR;
        }
    }

    protected KeyValue clientName(ClientRequestObservationContext context) {
        if (context.getCarrier() != null && ((ClientHttpRequest)context.getCarrier()).getURI().getHost() != null) {
            return KeyValue.of(ClientHttpObservationDocumentation.LowCardinalityKeyNames.CLIENT_NAME, ((ClientHttpRequest)context.getCarrier()).getURI().getHost());
        }
        return CLIENT_NAME_NONE;
    }

    protected KeyValue exception(ClientRequestObservationContext context) {
        Throwable error = context.getError();
        if (error != null) {
            String simpleName = error.getClass().getSimpleName();
            return KeyValue.of(ClientHttpObservationDocumentation.LowCardinalityKeyNames.EXCEPTION, StringUtils.hasText(simpleName) ? simpleName : error.getClass().getName());
        }
        return EXCEPTION_NONE;
    }

    protected KeyValue outcome(ClientRequestObservationContext context) {
        if (context.getResponse() != null) {
            try {
                return HttpOutcome.forStatus(((ClientHttpResponse)context.getResponse()).getStatusCode());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return HTTP_OUTCOME_UNKNOWN;
    }

    @Override
    public KeyValues getHighCardinalityKeyValues(ClientRequestObservationContext context) {
        return KeyValues.of(this.requestUri(context));
    }

    protected KeyValue requestUri(ClientRequestObservationContext context) {
        if (context.getCarrier() != null) {
            return KeyValue.of(ClientHttpObservationDocumentation.HighCardinalityKeyNames.HTTP_URL, ((ClientHttpRequest)context.getCarrier()).getURI().toASCIIString());
        }
        return HTTP_URL_NONE;
    }

    static class HttpOutcome {
        HttpOutcome() {
        }

        static KeyValue forStatus(HttpStatusCode statusCode) {
            if (statusCode.is2xxSuccessful()) {
                return HTTP_OUTCOME_SUCCESS;
            }
            if (statusCode instanceof HttpStatus) {
                HttpStatus status = (HttpStatus)statusCode;
                return KeyValue.of(ClientHttpObservationDocumentation.LowCardinalityKeyNames.OUTCOME, status.series().name());
            }
            return HTTP_OUTCOME_UNKNOWN;
        }
    }
}

