/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.codec;

import java.util.List;
import java.util.Map;
import keycloakjar.org.springframework.core.ResolvableType;
import keycloakjar.org.springframework.core.codec.CharSequenceEncoder;
import keycloakjar.org.springframework.core.codec.Encoder;
import keycloakjar.org.springframework.core.codec.EncodingException;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.core.io.buffer.DataBufferFactory;
import keycloakjar.org.springframework.http.codec.KotlinSerializationSupport;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.MimeType;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.StringFormat;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class KotlinSerializationStringEncoder<T extends StringFormat>
extends KotlinSerializationSupport<T>
implements Encoder<Object> {
    private final CharSequenceEncoder charSequenceEncoder = CharSequenceEncoder.allMimeTypes();

    protected KotlinSerializationStringEncoder(T format, MimeType ... supportedMimeTypes) {
        super(format, supportedMimeTypes);
    }

    @Override
    public boolean canEncode(ResolvableType elementType, @Nullable MimeType mimeType) {
        return this.canSerialize(elementType, mimeType);
    }

    @Override
    public List<MimeType> getEncodableMimeTypes() {
        return this.supportedMimeTypes();
    }

    @Override
    public List<MimeType> getEncodableMimeTypes(ResolvableType elementType) {
        return this.supportedMimeTypes();
    }

    @Override
    public Flux<DataBuffer> encode(Publisher<?> inputStream, DataBufferFactory bufferFactory, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        if (inputStream instanceof Mono) {
            return Mono.from(inputStream).map(value -> this.encodeValue(value, bufferFactory, elementType, mimeType, hints)).flux();
        }
        ResolvableType listType = ResolvableType.forClassWithGenerics(List.class, elementType);
        return Flux.from(inputStream).collectList().map(list -> this.encodeValue(list, bufferFactory, listType, mimeType, hints)).flux();
    }

    @Override
    public DataBuffer encodeValue(Object value, DataBufferFactory bufferFactory, ResolvableType valueType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        KSerializer<Object> serializer = this.serializer(valueType);
        if (serializer == null) {
            throw new EncodingException("Could not find KSerializer for " + valueType);
        }
        String string = ((StringFormat)this.format()).encodeToString(serializer, value);
        return this.charSequenceEncoder.encodeValue(string, bufferFactory, valueType, mimeType, (Map<String, Object>)null);
    }
}

