/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.codec.multipart;

import java.util.Collections;
import java.util.Map;
import keycloakjar.org.springframework.core.ResolvableType;
import keycloakjar.org.springframework.core.codec.Hints;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.core.io.buffer.DataBufferFactory;
import keycloakjar.org.springframework.core.io.buffer.DataBufferUtils;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.MediaType;
import keycloakjar.org.springframework.http.ReactiveHttpOutputMessage;
import keycloakjar.org.springframework.http.codec.HttpMessageWriter;
import keycloakjar.org.springframework.http.codec.multipart.MultipartWriterSupport;
import keycloakjar.org.springframework.http.codec.multipart.PartEvent;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PartEventHttpMessageWriter
extends MultipartWriterSupport
implements HttpMessageWriter<PartEvent> {
    public PartEventHttpMessageWriter() {
        super(Collections.singletonList(MediaType.MULTIPART_FORM_DATA));
    }

    @Override
    public boolean canWrite(ResolvableType elementType, @Nullable MediaType mediaType) {
        if (PartEvent.class.isAssignableFrom(elementType.toClass())) {
            if (mediaType == null) {
                return true;
            }
            for (MediaType supportedMediaType : this.getWritableMediaTypes()) {
                if (!supportedMediaType.isCompatibleWith(mediaType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Mono<Void> write(Publisher<? extends PartEvent> partDataStream, ResolvableType elementType, @Nullable MediaType mediaType, ReactiveHttpOutputMessage outputMessage, Map<String, Object> hints) {
        byte[] boundary = this.generateMultipartBoundary();
        mediaType = this.getMultipartMediaType(mediaType, boundary);
        outputMessage.getHeaders().setContentType(mediaType);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(Hints.getLogPrefix(hints) + "Encoding Publisher<PartEvent>");
        }
        Flux body = Flux.from(partDataStream).windowUntil(PartEvent::isLast).concatMap(partData -> partData.switchOnFirst((signal, flux) -> {
            if (signal.hasValue()) {
                PartEvent value = (PartEvent)signal.get();
                Assert.state(value != null, "Null value");
                Flux dataBuffers = flux.map(PartEvent::content).filter(buffer -> buffer.readableByteCount() > 0);
                return this.encodePartData(boundary, outputMessage.bufferFactory(), value.headers(), (Flux<DataBuffer>)dataBuffers);
            }
            return flux.cast(DataBuffer.class);
        })).concatWith(this.generateLastLine(boundary, outputMessage.bufferFactory())).doOnDiscard(DataBuffer.class, DataBufferUtils::release);
        if (this.logger.isDebugEnabled()) {
            body = body.doOnNext(buffer -> Hints.touchDataBuffer(buffer, hints, this.logger));
        }
        return outputMessage.writeWith((Publisher<? extends DataBuffer>)body);
    }

    private Flux<DataBuffer> encodePartData(byte[] boundary, DataBufferFactory bufferFactory, HttpHeaders headers, Flux<DataBuffer> body) {
        return Flux.concat((Publisher[])new Publisher[]{this.generateBoundaryLine(boundary, bufferFactory), this.generatePartHeaders(headers, bufferFactory), body, this.generateNewLine(bufferFactory)});
    }
}

