/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import keycloakjar.org.springframework.core.ResolvableType;
import keycloakjar.org.springframework.core.log.LogFormatUtils;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpStatus;
import keycloakjar.org.springframework.http.HttpStatusCode;
import keycloakjar.org.springframework.http.MediaType;
import keycloakjar.org.springframework.http.client.ClientHttpResponse;
import keycloakjar.org.springframework.http.converter.HttpMessageConverter;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.CollectionUtils;
import keycloakjar.org.springframework.util.FileCopyUtils;
import keycloakjar.org.springframework.util.ObjectUtils;
import keycloakjar.org.springframework.web.client.ClientHttpResponseDecorator;
import keycloakjar.org.springframework.web.client.HttpClientErrorException;
import keycloakjar.org.springframework.web.client.HttpMessageConverterExtractor;
import keycloakjar.org.springframework.web.client.HttpServerErrorException;
import keycloakjar.org.springframework.web.client.ResponseErrorHandler;
import keycloakjar.org.springframework.web.client.RestClientException;
import keycloakjar.org.springframework.web.client.RestClientResponseException;
import keycloakjar.org.springframework.web.client.UnknownHttpStatusCodeException;

public class DefaultResponseErrorHandler
implements ResponseErrorHandler {
    @Nullable
    private List<HttpMessageConverter<?>> messageConverters;

    void setMessageConverters(List<HttpMessageConverter<?>> converters) {
        this.messageConverters = Collections.unmodifiableList(converters);
    }

    @Override
    public boolean hasError(ClientHttpResponse response) throws IOException {
        HttpStatusCode statusCode = response.getStatusCode();
        return this.hasError(statusCode);
    }

    protected boolean hasError(HttpStatusCode statusCode) {
        return statusCode.isError();
    }

    @Deprecated
    protected boolean hasError(int statusCode) {
        HttpStatus.Series series = HttpStatus.Series.resolve(statusCode);
        return series == HttpStatus.Series.CLIENT_ERROR || series == HttpStatus.Series.SERVER_ERROR;
    }

    @Override
    public void handleError(ClientHttpResponse response) throws IOException {
        HttpStatusCode statusCode = response.getStatusCode();
        this.handleError(response, statusCode);
    }

    private String getErrorMessage(int rawStatusCode, String statusText, @Nullable byte[] responseBody, @Nullable Charset charset) {
        String preface = rawStatusCode + " " + statusText + ": ";
        if (ObjectUtils.isEmpty((Object)responseBody)) {
            return preface + "[no body]";
        }
        charset = charset != null ? charset : StandardCharsets.UTF_8;
        String bodyText = new String(responseBody, charset);
        bodyText = LogFormatUtils.formatValue(bodyText, -1, true);
        return preface + bodyText;
    }

    protected void handleError(ClientHttpResponse response, HttpStatusCode statusCode) throws IOException {
        String statusText = response.getStatusText();
        HttpHeaders headers = response.getHeaders();
        byte[] body = this.getResponseBody(response);
        Charset charset = this.getCharset(response);
        String message = this.getErrorMessage(statusCode.value(), statusText, body, charset);
        RestClientResponseException ex = statusCode.is4xxClientError() ? HttpClientErrorException.create(message, statusCode, statusText, headers, body, charset) : (statusCode.is5xxServerError() ? HttpServerErrorException.create(message, statusCode, statusText, headers, body, charset) : new UnknownHttpStatusCodeException(message, statusCode.value(), statusText, headers, body, charset));
        if (!CollectionUtils.isEmpty(this.messageConverters)) {
            ex.setBodyConvertFunction(this.initBodyConvertFunction(response, body));
        }
        throw ex;
    }

    protected Function<ResolvableType, ?> initBodyConvertFunction(ClientHttpResponse response, final byte[] body) {
        Assert.state(!CollectionUtils.isEmpty(this.messageConverters), "Expected message converters");
        return resolvableType -> {
            try {
                HttpMessageConverterExtractor extractor = new HttpMessageConverterExtractor(resolvableType.getType(), this.messageConverters);
                return extractor.extractData(new ClientHttpResponseDecorator(response){

                    @Override
                    public InputStream getBody() {
                        return new ByteArrayInputStream(body);
                    }
                });
            }
            catch (IOException ex) {
                throw new RestClientException("Error while extracting response for type [" + resolvableType + "]", ex);
            }
        };
    }

    protected byte[] getResponseBody(ClientHttpResponse response) {
        try {
            return FileCopyUtils.copyToByteArray(response.getBody());
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }

    @Nullable
    protected Charset getCharset(ClientHttpResponse response) {
        HttpHeaders headers = response.getHeaders();
        MediaType contentType = headers.getContentType();
        return contentType != null ? contentType.getCharset() : null;
    }
}

