/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.service.annotation;

import java.util.ArrayList;
import java.util.List;
import keycloakjar.org.springframework.aop.framework.AopProxyUtils;
import keycloakjar.org.springframework.aot.generate.GenerationContext;
import keycloakjar.org.springframework.aot.hint.ProxyHints;
import keycloakjar.org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import keycloakjar.org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import keycloakjar.org.springframework.beans.factory.aot.BeanRegistrationCode;
import keycloakjar.org.springframework.beans.factory.support.RegisteredBean;
import keycloakjar.org.springframework.core.annotation.MergedAnnotations;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.ClassUtils;
import keycloakjar.org.springframework.util.ReflectionUtils;
import keycloakjar.org.springframework.web.service.annotation.HttpExchange;

class HttpExchangeBeanRegistrationAotProcessor
implements BeanRegistrationAotProcessor {
    HttpExchangeBeanRegistrationAotProcessor() {
    }

    @Override
    @Nullable
    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        Class<?> beanClass = registeredBean.getBeanClass();
        ArrayList exchangeInterfaces = new ArrayList();
        MergedAnnotations.Search search = MergedAnnotations.search(MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
        for (Class<?> interfaceClass : ClassUtils.getAllInterfacesForClass(beanClass)) {
            ReflectionUtils.doWithMethods(interfaceClass, method -> {
                if (!exchangeInterfaces.contains(interfaceClass) && search.from(method).isPresent(HttpExchange.class)) {
                    exchangeInterfaces.add(interfaceClass);
                }
            });
        }
        if (!exchangeInterfaces.isEmpty()) {
            return new HttpExchangeBeanRegistrationAotContribution(exchangeInterfaces);
        }
        return null;
    }

    private static class HttpExchangeBeanRegistrationAotContribution
    implements BeanRegistrationAotContribution {
        private final List<Class<?>> httpExchangeInterfaces;

        public HttpExchangeBeanRegistrationAotContribution(List<Class<?>> httpExchangeInterfaces) {
            this.httpExchangeInterfaces = httpExchangeInterfaces;
        }

        @Override
        public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
            ProxyHints proxyHints = generationContext.getRuntimeHints().proxies();
            for (Class<?> httpExchangeInterface : this.httpExchangeInterfaces) {
                proxyHints.registerJdkProxy(AopProxyUtils.completeJdkProxyInterfaces((Class[])new Class[]{httpExchangeInterface}));
            }
        }
    }
}

