/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.service.invoker;

import keycloakjar.org.springframework.core.MethodParameter;
import keycloakjar.org.springframework.core.ParameterizedTypeReference;
import keycloakjar.org.springframework.core.ReactiveAdapter;
import keycloakjar.org.springframework.core.ReactiveAdapterRegistry;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.web.bind.annotation.RequestBody;
import keycloakjar.org.springframework.web.service.invoker.HttpRequestValues;
import keycloakjar.org.springframework.web.service.invoker.HttpServiceArgumentResolver;

public class RequestBodyArgumentResolver
implements HttpServiceArgumentResolver {
    private final ReactiveAdapterRegistry reactiveAdapterRegistry;

    public RequestBodyArgumentResolver(ReactiveAdapterRegistry reactiveAdapterRegistry) {
        Assert.notNull((Object)reactiveAdapterRegistry, "ReactiveAdapterRegistry is required");
        this.reactiveAdapterRegistry = reactiveAdapterRegistry;
    }

    @Override
    public boolean resolve(@Nullable Object argument, MethodParameter parameter, HttpRequestValues.Builder requestValues) {
        RequestBody annot = parameter.getParameterAnnotation(RequestBody.class);
        if (annot == null) {
            return false;
        }
        if (argument != null) {
            ReactiveAdapter reactiveAdapter = this.reactiveAdapterRegistry.getAdapter(parameter.getParameterType());
            if (reactiveAdapter == null) {
                requestValues.setBodyValue(argument);
            } else {
                MethodParameter nestedParameter = parameter.nested();
                String message = "Async type for @RequestBody should produce value(s)";
                Assert.isTrue(!reactiveAdapter.isNoValue(), message);
                Assert.isTrue(nestedParameter.getNestedParameterType() != Void.class, message);
                requestValues.setBody(reactiveAdapter.toPublisher(argument), ParameterizedTypeReference.forType(nestedParameter.getNestedGenericParameterType()));
            }
        }
        return true;
    }
}

