/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.service.invoker;

import keycloakjar.org.springframework.core.MethodParameter;
import keycloakjar.org.springframework.core.ReactiveAdapter;
import keycloakjar.org.springframework.core.ReactiveAdapterRegistry;
import keycloakjar.org.springframework.core.ResolvableType;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.web.bind.annotation.RequestPart;
import keycloakjar.org.springframework.web.service.invoker.AbstractNamedValueArgumentResolver;
import keycloakjar.org.springframework.web.service.invoker.HttpRequestValues;
import org.reactivestreams.Publisher;

public class RequestPartArgumentResolver
extends AbstractNamedValueArgumentResolver {
    private final ReactiveAdapterRegistry reactiveAdapterRegistry;

    public RequestPartArgumentResolver(ReactiveAdapterRegistry reactiveAdapterRegistry) {
        this.reactiveAdapterRegistry = reactiveAdapterRegistry;
    }

    @Override
    protected AbstractNamedValueArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        RequestPart annot = parameter.getParameterAnnotation(RequestPart.class);
        return annot == null ? null : new AbstractNamedValueArgumentResolver.NamedValueInfo(annot.name(), annot.required(), null, "request part", true);
    }

    @Override
    protected void addRequestValue(String name, Object value, MethodParameter parameter, HttpRequestValues.Builder requestValues) {
        Class<?> type = parameter.getParameterType();
        ReactiveAdapter adapter = this.reactiveAdapterRegistry.getAdapter(type);
        if (adapter != null) {
            Assert.isTrue(!adapter.isNoValue(), "Expected publisher that produces a value");
            Publisher publisher = adapter.toPublisher(value);
            requestValues.addRequestPart(name, publisher, ResolvableType.forMethodParameter(parameter.nested()));
        } else {
            requestValues.addRequestPart(name, value);
        }
    }
}

