/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.aot.hint;

import java.util.List;
import java.util.function.Consumer;
import keycloakjar.org.springframework.aot.hint.ExecutableMode;
import keycloakjar.org.springframework.aot.hint.MemberHint;
import keycloakjar.org.springframework.aot.hint.TypeReference;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;

public final class ExecutableHint
extends MemberHint {
    private final List<TypeReference> parameterTypes;
    private final ExecutableMode mode;

    private ExecutableHint(Builder builder) {
        super(builder.name);
        this.parameterTypes = List.copyOf(builder.parameterTypes);
        this.mode = builder.mode != null ? builder.mode : ExecutableMode.INVOKE;
    }

    static Builder ofConstructor(List<TypeReference> parameterTypes) {
        return new Builder("<init>", parameterTypes);
    }

    static Builder ofMethod(String name, List<TypeReference> parameterTypes) {
        return new Builder(name, parameterTypes);
    }

    public List<TypeReference> getParameterTypes() {
        return this.parameterTypes;
    }

    public ExecutableMode getMode() {
        return this.mode;
    }

    public static Consumer<Builder> builtWith(ExecutableMode mode) {
        return builder -> builder.withMode(mode);
    }

    public static class Builder {
        private final String name;
        private final List<TypeReference> parameterTypes;
        @Nullable
        private ExecutableMode mode;

        Builder(String name, List<TypeReference> parameterTypes) {
            this.name = name;
            this.parameterTypes = parameterTypes;
        }

        public Builder withMode(ExecutableMode mode) {
            Assert.notNull((Object)mode, "'mode' must not be null");
            if (this.mode == null || !this.mode.includes(mode)) {
                this.mode = mode;
            }
            return this;
        }

        ExecutableHint build() {
            return new ExecutableHint(this);
        }
    }
}

