/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.aot.nativex;

import java.util.LinkedHashMap;
import java.util.Map;
import keycloakjar.org.springframework.aot.hint.JdkProxyHint;
import keycloakjar.org.springframework.aot.hint.ProxyHints;
import keycloakjar.org.springframework.aot.hint.TypeReference;
import keycloakjar.org.springframework.aot.nativex.BasicJsonWriter;

class ProxyHintsWriter {
    public static final ProxyHintsWriter INSTANCE = new ProxyHintsWriter();

    ProxyHintsWriter() {
    }

    public void write(BasicJsonWriter writer, ProxyHints hints) {
        writer.writeArray(hints.jdkProxyHints().map(this::toAttributes).toList());
    }

    private Map<String, Object> toAttributes(JdkProxyHint hint) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        this.handleCondition(attributes, hint);
        attributes.put("interfaces", hint.getProxiedInterfaces());
        return attributes;
    }

    private void handleCondition(Map<String, Object> attributes, JdkProxyHint hint) {
        if (hint.getReachableType() != null) {
            LinkedHashMap<String, TypeReference> conditionAttributes = new LinkedHashMap<String, TypeReference>();
            conditionAttributes.put("typeReachable", hint.getReachableType());
            attributes.put("condition", conditionAttributes);
        }
    }
}

