/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import keycloakjar.org.springframework.core.annotation.AnnotationConfigurationException;
import keycloakjar.org.springframework.core.annotation.AnnotationUtils;
import keycloakjar.org.springframework.core.annotation.AttributeMethods;
import keycloakjar.org.springframework.core.annotation.MergedAnnotation;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.ClassUtils;
import keycloakjar.org.springframework.util.ObjectUtils;
import keycloakjar.org.springframework.util.ReflectionUtils;

final class SynthesizedMergedAnnotationInvocationHandler<A extends Annotation>
implements InvocationHandler {
    private final MergedAnnotation<?> annotation;
    private final Class<A> type;
    private final AttributeMethods attributes;
    private final Map<String, Object> valueCache = new ConcurrentHashMap<String, Object>(8);
    @Nullable
    private volatile Integer hashCode;
    @Nullable
    private volatile String string;

    private SynthesizedMergedAnnotationInvocationHandler(MergedAnnotation<A> annotation, Class<A> type) {
        Assert.notNull(annotation, "MergedAnnotation must not be null");
        Assert.notNull(type, "Type must not be null");
        Assert.isTrue(type.isAnnotation(), "Type must be an annotation");
        this.annotation = annotation;
        this.type = type;
        this.attributes = AttributeMethods.forAnnotationType(type);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        if (ReflectionUtils.isEqualsMethod(method)) {
            return this.annotationEquals(args[0]);
        }
        if (ReflectionUtils.isHashCodeMethod(method)) {
            return this.annotationHashCode();
        }
        if (ReflectionUtils.isToStringMethod(method)) {
            return this.annotationToString();
        }
        if (this.isAnnotationTypeMethod(method)) {
            return this.type;
        }
        if (this.attributes.indexOf(method.getName()) != -1) {
            return this.getAttributeValue(method);
        }
        throw new AnnotationConfigurationException(String.format("Method [%s] is unsupported for synthesized annotation type [%s]", method, this.type));
    }

    private boolean isAnnotationTypeMethod(Method method) {
        return method.getName().equals("annotationType") && method.getParameterCount() == 0;
    }

    private boolean annotationEquals(Object other) {
        if (this == other) {
            return true;
        }
        if (!this.type.isInstance(other)) {
            return false;
        }
        for (int i = 0; i < this.attributes.size(); ++i) {
            Object otherValue;
            Method attribute = this.attributes.get(i);
            Object thisValue = this.getAttributeValue(attribute);
            if (ObjectUtils.nullSafeEquals(thisValue, otherValue = AnnotationUtils.invokeAnnotationMethod(attribute, other))) continue;
            return false;
        }
        return true;
    }

    private int annotationHashCode() {
        Integer hashCode = this.hashCode;
        if (hashCode == null) {
            this.hashCode = hashCode = this.computeHashCode();
        }
        return hashCode;
    }

    private Integer computeHashCode() {
        int hashCode = 0;
        for (int i = 0; i < this.attributes.size(); ++i) {
            Method attribute = this.attributes.get(i);
            Object value = this.getAttributeValue(attribute);
            hashCode += 127 * attribute.getName().hashCode() ^ this.getValueHashCode(value);
        }
        return hashCode;
    }

    private int getValueHashCode(Object value) {
        if (value instanceof boolean[]) {
            boolean[] booleans = (boolean[])value;
            return Arrays.hashCode(booleans);
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return Arrays.hashCode(bytes);
        }
        if (value instanceof char[]) {
            char[] chars = (char[])value;
            return Arrays.hashCode(chars);
        }
        if (value instanceof double[]) {
            double[] doubles = (double[])value;
            return Arrays.hashCode(doubles);
        }
        if (value instanceof float[]) {
            float[] floats = (float[])value;
            return Arrays.hashCode(floats);
        }
        if (value instanceof int[]) {
            int[] ints = (int[])value;
            return Arrays.hashCode(ints);
        }
        if (value instanceof long[]) {
            long[] longs = (long[])value;
            return Arrays.hashCode(longs);
        }
        if (value instanceof short[]) {
            short[] shorts = (short[])value;
            return Arrays.hashCode(shorts);
        }
        if (value instanceof Object[]) {
            Object[] objects = (Object[])value;
            return Arrays.hashCode(objects);
        }
        return value.hashCode();
    }

    private String annotationToString() {
        String string = this.string;
        if (string == null) {
            StringBuilder builder = new StringBuilder("@").append(SynthesizedMergedAnnotationInvocationHandler.getName(this.type)).append('(');
            for (int i = 0; i < this.attributes.size(); ++i) {
                Method attribute = this.attributes.get(i);
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(attribute.getName());
                builder.append('=');
                builder.append(this.toString(this.getAttributeValue(attribute)));
            }
            builder.append(')');
            this.string = string = builder.toString();
        }
        return string;
    }

    private String toString(Object value) {
        if (value instanceof String) {
            String str = (String)value;
            return "\"" + str + "\"";
        }
        if (value instanceof Character) {
            return "'" + value.toString() + "'";
        }
        if (value instanceof Byte) {
            return String.format("(byte) 0x%02X", value);
        }
        if (value instanceof Long) {
            Long longValue = (Long)value;
            return Long.toString(longValue) + "L";
        }
        if (value instanceof Float) {
            Float floatValue = (Float)value;
            return Float.toString(floatValue.floatValue()) + "f";
        }
        if (value instanceof Double) {
            Double doubleValue = (Double)value;
            return Double.toString(doubleValue) + "d";
        }
        if (value instanceof Enum) {
            Enum e = (Enum)value;
            return e.name();
        }
        if (value instanceof Class) {
            Class clazz = (Class)value;
            return SynthesizedMergedAnnotationInvocationHandler.getName(clazz) + ".class";
        }
        if (value.getClass().isArray()) {
            StringBuilder builder = new StringBuilder("{");
            for (int i = 0; i < Array.getLength(value); ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(this.toString(Array.get(value, i)));
            }
            builder.append('}');
            return builder.toString();
        }
        return String.valueOf(value);
    }

    private Object getAttributeValue(Method method) {
        Object value = this.valueCache.computeIfAbsent(method.getName(), attributeName -> {
            Class<?> type = ClassUtils.resolvePrimitiveIfNecessary(method.getReturnType());
            return this.annotation.getValue((String)attributeName, type).orElseThrow(() -> new NoSuchElementException("No value found for attribute named '" + attributeName + "' in merged annotation " + this.annotation.getType().getName()));
        });
        if (value.getClass().isArray() && Array.getLength(value) > 0) {
            value = this.cloneArray(value);
        }
        return value;
    }

    private Object cloneArray(Object array) {
        if (array instanceof boolean[]) {
            boolean[] booleans = (boolean[])array;
            return booleans.clone();
        }
        if (array instanceof byte[]) {
            byte[] bytes = (byte[])array;
            return bytes.clone();
        }
        if (array instanceof char[]) {
            char[] chars = (char[])array;
            return chars.clone();
        }
        if (array instanceof double[]) {
            double[] doubles = (double[])array;
            return doubles.clone();
        }
        if (array instanceof float[]) {
            float[] floats = (float[])array;
            return floats.clone();
        }
        if (array instanceof int[]) {
            int[] ints = (int[])array;
            return ints.clone();
        }
        if (array instanceof long[]) {
            long[] longs = (long[])array;
            return longs.clone();
        }
        if (array instanceof short[]) {
            short[] shorts = (short[])array;
            return shorts.clone();
        }
        return ((Object[])array).clone();
    }

    static <A extends Annotation> A createProxy(MergedAnnotation<A> annotation, Class<A> type) {
        ClassLoader classLoader = type.getClassLoader();
        Class[] interfaces = new Class[]{type};
        SynthesizedMergedAnnotationInvocationHandler<A> handler = new SynthesizedMergedAnnotationInvocationHandler<A>(annotation, type);
        return (A)((Annotation)Proxy.newProxyInstance(classLoader, interfaces, handler));
    }

    private static String getName(Class<?> clazz) {
        String canonicalName = clazz.getCanonicalName();
        return canonicalName != null ? canonicalName : clazz.getName();
    }
}

