/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.client.reactive;

import io.netty5.buffer.Buffer;
import io.netty5.handler.codec.http.headers.DefaultHttpCookiePair;
import io.netty5.handler.codec.http.headers.HttpCookiePair;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiConsumer;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.core.io.buffer.DataBufferFactory;
import keycloakjar.org.springframework.core.io.buffer.Netty5DataBufferFactory;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpMethod;
import keycloakjar.org.springframework.http.ZeroCopyHttpOutputMessage;
import keycloakjar.org.springframework.http.client.reactive.AbstractClientHttpRequest;
import keycloakjar.org.springframework.http.client.reactive.Netty5HeadersAdapter;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty5.NettyOutbound;
import reactor.netty5.http.client.HttpClientRequest;

class ReactorNetty2ClientHttpRequest
extends AbstractClientHttpRequest
implements ZeroCopyHttpOutputMessage {
    private final HttpMethod httpMethod;
    private final URI uri;
    private final HttpClientRequest request;
    private final NettyOutbound outbound;
    private final Netty5DataBufferFactory bufferFactory;

    public ReactorNetty2ClientHttpRequest(HttpMethod method, URI uri, HttpClientRequest request, NettyOutbound outbound) {
        this.httpMethod = method;
        this.uri = uri;
        this.request = request;
        this.outbound = outbound;
        this.bufferFactory = new Netty5DataBufferFactory(outbound.alloc());
    }

    @Override
    public HttpMethod getMethod() {
        return this.httpMethod;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public DataBufferFactory bufferFactory() {
        return this.bufferFactory;
    }

    @Override
    public <T> T getNativeRequest() {
        return (T)this.request;
    }

    @Override
    public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
        return this.doCommit(() -> {
            if (body instanceof Mono) {
                Mono bufferMono = Mono.from((Publisher)body).map(Netty5DataBufferFactory::toBuffer);
                return this.outbound.send((Publisher)bufferMono).then();
            }
            Flux bufferFlux = Flux.from((Publisher)body).map(Netty5DataBufferFactory::toBuffer);
            return this.outbound.send((Publisher)bufferFlux).then();
        });
    }

    @Override
    public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body) {
        Flux buffers = Flux.from(body).map(ReactorNetty2ClientHttpRequest::toBuffers);
        return this.doCommit(() -> this.lambda$writeAndFlushWith$1((Publisher)buffers));
    }

    private static Publisher<Buffer> toBuffers(Publisher<? extends DataBuffer> dataBuffers) {
        return Flux.from(dataBuffers).map(Netty5DataBufferFactory::toBuffer);
    }

    @Override
    public Mono<Void> writeWith(Path file, long position, long count) {
        return this.doCommit(() -> this.outbound.sendFile(file, position, count).then());
    }

    @Override
    public Mono<Void> setComplete() {
        return this.doCommit(() -> ((NettyOutbound)this.outbound).then());
    }

    @Override
    protected void applyHeaders() {
        this.getHeaders().forEach((BiConsumer<? super String, ? super List<String>>)((BiConsumer<String, List>)(key, value) -> this.request.requestHeaders().set((CharSequence)key, (Iterable)value)));
    }

    @Override
    protected void applyCookies() {
        this.getCookies().values().forEach(values -> values.forEach(value -> {
            DefaultHttpCookiePair cookie = new DefaultHttpCookiePair((CharSequence)value.getName(), (CharSequence)value.getValue());
            this.request.addCookie((HttpCookiePair)cookie);
        }));
    }

    @Override
    protected HttpHeaders initReadOnlyHeaders() {
        return HttpHeaders.readOnlyHttpHeaders(new Netty5HeadersAdapter(this.request.requestHeaders()));
    }

    private /* synthetic */ Publisher lambda$writeAndFlushWith$1(Publisher buffers) {
        return this.outbound.sendGroups(buffers).then();
    }
}

