/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.codec;

import java.util.List;
import java.util.Map;
import keycloakjar.org.springframework.core.ResolvableType;
import keycloakjar.org.springframework.core.codec.Decoder;
import keycloakjar.org.springframework.core.codec.DecodingException;
import keycloakjar.org.springframework.core.codec.StringDecoder;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.http.codec.KotlinSerializationSupport;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.MimeType;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.StringFormat;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class KotlinSerializationStringDecoder<T extends StringFormat>
extends KotlinSerializationSupport<T>
implements Decoder<Object> {
    private final StringDecoder stringDecoder = StringDecoder.allMimeTypes(StringDecoder.DEFAULT_DELIMITERS, false);

    public KotlinSerializationStringDecoder(T format, MimeType ... supportedMimeTypes) {
        super(format, supportedMimeTypes);
    }

    public void setMaxInMemorySize(int byteCount) {
        this.stringDecoder.setMaxInMemorySize(byteCount);
    }

    public int getMaxInMemorySize() {
        return this.stringDecoder.getMaxInMemorySize();
    }

    @Override
    public boolean canDecode(ResolvableType elementType, @Nullable MimeType mimeType) {
        return this.canSerialize(elementType, mimeType);
    }

    @Override
    public List<MimeType> getDecodableMimeTypes() {
        return this.supportedMimeTypes();
    }

    @Override
    public List<MimeType> getDecodableMimeTypes(ResolvableType targetType) {
        return this.supportedMimeTypes();
    }

    @Override
    public Flux<Object> decode(Publisher<DataBuffer> inputStream, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return Flux.error((Throwable)new UnsupportedOperationException());
    }

    @Override
    public Mono<Object> decodeToMono(Publisher<DataBuffer> inputStream, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return Mono.defer(() -> {
            KSerializer<Object> serializer = this.serializer(elementType);
            if (serializer == null) {
                return Mono.error((Throwable)new DecodingException("Could not find KSerializer for " + elementType));
            }
            return this.stringDecoder.decodeToMono(inputStream, elementType, mimeType, hints).map(string -> ((StringFormat)this.format()).decodeFromString((DeserializationStrategy)serializer, string));
        });
    }
}

