/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.codec.multipart;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import keycloakjar.org.springframework.core.ResolvableType;
import keycloakjar.org.springframework.core.codec.DecodingException;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.core.io.buffer.DataBufferUtils;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.MediaType;
import keycloakjar.org.springframework.http.ReactiveHttpInputMessage;
import keycloakjar.org.springframework.http.codec.HttpMessageReader;
import keycloakjar.org.springframework.http.codec.LoggingCodecSupport;
import keycloakjar.org.springframework.http.codec.multipart.DefaultPartEvents;
import keycloakjar.org.springframework.http.codec.multipart.MultipartParser;
import keycloakjar.org.springframework.http.codec.multipart.MultipartUtils;
import keycloakjar.org.springframework.http.codec.multipart.PartEvent;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PartEventHttpMessageReader
extends LoggingCodecSupport
implements HttpMessageReader<PartEvent> {
    private int maxInMemorySize = 262144;
    private int maxHeadersSize = 10240;
    private Charset headersCharset = StandardCharsets.UTF_8;

    public int getMaxInMemorySize() {
        return this.maxInMemorySize;
    }

    public void setMaxInMemorySize(int maxInMemorySize) {
        this.maxInMemorySize = maxInMemorySize;
    }

    public void setMaxHeadersSize(int byteCount) {
        this.maxHeadersSize = byteCount;
    }

    public void setHeadersCharset(Charset headersCharset) {
        Assert.notNull((Object)headersCharset, "Charset must not be null");
        this.headersCharset = headersCharset;
    }

    @Override
    public List<MediaType> getReadableMediaTypes() {
        return Collections.singletonList(MediaType.MULTIPART_FORM_DATA);
    }

    @Override
    public boolean canRead(ResolvableType elementType, @Nullable MediaType mediaType) {
        return PartEvent.class.equals(elementType.toClass()) && (mediaType == null || MediaType.MULTIPART_FORM_DATA.isCompatibleWith(mediaType));
    }

    @Override
    public Mono<PartEvent> readMono(ResolvableType elementType, ReactiveHttpInputMessage message, Map<String, Object> hints) {
        return Mono.error((Throwable)new UnsupportedOperationException("Cannot read multipart request body into single PartEvent"));
    }

    @Override
    public Flux<PartEvent> read(ResolvableType elementType, ReactiveHttpInputMessage message, Map<String, Object> hints) {
        return Flux.defer(() -> {
            byte[] boundary = MultipartUtils.boundary(message, this.headersCharset);
            if (boundary == null) {
                return Flux.error((Throwable)new DecodingException("No multipart boundary found in Content-Type: \"" + message.getHeaders().getContentType() + "\""));
            }
            return MultipartParser.parse(message.getBody(), boundary, this.maxHeadersSize, this.headersCharset).windowUntil(t2 -> t2 instanceof MultipartParser.HeadersToken, true).concatMap(tokens -> tokens.switchOnFirst((signal, flux) -> {
                if (signal.hasValue()) {
                    MultipartParser.HeadersToken headersToken = (MultipartParser.HeadersToken)signal.get();
                    Assert.state(headersToken != null, "Signal should be headers token");
                    HttpHeaders headers = headersToken.headers();
                    Flux bodyTokens = flux.filter(t2 -> t2 instanceof MultipartParser.BodyToken).cast(MultipartParser.BodyToken.class);
                    return this.createEvents(headers, (Flux<MultipartParser.BodyToken>)bodyTokens);
                }
                return flux.cast(PartEvent.class);
            }));
        });
    }

    private Publisher<? extends PartEvent> createEvents(HttpHeaders headers, Flux<MultipartParser.BodyToken> bodyTokens) {
        if (MultipartUtils.isFormField(headers)) {
            Flux contents = bodyTokens.map(MultipartParser.BodyToken::buffer);
            return DataBufferUtils.join((Publisher<? extends DataBuffer>)contents, this.maxInMemorySize).map(content -> {
                String value = content.toString(MultipartUtils.charset(headers));
                DataBufferUtils.release(content);
                return DefaultPartEvents.form(headers, value);
            }).switchIfEmpty(Mono.fromCallable(() -> DefaultPartEvents.form(headers)));
        }
        if (headers.getContentDisposition().getFilename() != null) {
            return bodyTokens.map(body -> DefaultPartEvents.file(headers, body.buffer(), body.isLast())).switchIfEmpty((Publisher)Mono.fromCallable(() -> DefaultPartEvents.file(headers)));
        }
        return bodyTokens.map(body -> DefaultPartEvents.create(headers, body.buffer(), body.isLast())).switchIfEmpty((Publisher)Mono.fromCallable(() -> DefaultPartEvents.create(headers)));
    }
}

