/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.server.reactive;

import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import keycloakjar.org.springframework.http.HttpCookie;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpMethod;
import keycloakjar.org.springframework.http.server.RequestPath;
import keycloakjar.org.springframework.http.server.reactive.ServerHttpRequest;
import keycloakjar.org.springframework.http.server.reactive.SslInfo;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.CollectionUtils;
import keycloakjar.org.springframework.util.LinkedMultiValueMap;
import keycloakjar.org.springframework.util.MultiValueMap;
import keycloakjar.org.springframework.util.ObjectUtils;
import keycloakjar.org.springframework.util.StringUtils;

public abstract class AbstractServerHttpRequest
implements ServerHttpRequest {
    private static final Pattern QUERY_PATTERN = Pattern.compile("([^&=]+)(=?)([^&]+)?");
    private final URI uri;
    private final RequestPath path;
    private final HttpHeaders headers;
    @Nullable
    private final HttpMethod method;
    @Nullable
    private MultiValueMap<String, String> queryParams;
    @Nullable
    private MultiValueMap<String, HttpCookie> cookies;
    @Nullable
    private SslInfo sslInfo;
    @Nullable
    private String id;
    @Nullable
    private String logPrefix;

    @Deprecated(since="6.0.8", forRemoval=true)
    public AbstractServerHttpRequest(URI uri, @Nullable String contextPath, MultiValueMap<String, String> headers) {
        this.uri = uri;
        this.path = RequestPath.parse(uri, contextPath);
        this.headers = HttpHeaders.readOnlyHttpHeaders(headers);
        this.method = null;
    }

    public AbstractServerHttpRequest(HttpMethod method, URI uri, @Nullable String contextPath, MultiValueMap<String, String> headers) {
        Assert.notNull((Object)method, "Method must not be null");
        Assert.notNull((Object)uri, "Uri must not be null");
        Assert.notNull(headers, "Headers must not be null");
        this.method = method;
        this.uri = uri;
        this.path = RequestPath.parse(uri, contextPath);
        this.headers = HttpHeaders.readOnlyHttpHeaders(headers);
    }

    @Deprecated(since="6.0.8", forRemoval=true)
    public AbstractServerHttpRequest(URI uri, @Nullable String contextPath, HttpHeaders headers) {
        this.uri = uri;
        this.path = RequestPath.parse(uri, contextPath);
        this.headers = HttpHeaders.readOnlyHttpHeaders(headers);
        this.method = null;
    }

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = this.initId();
            if (this.id == null) {
                this.id = ObjectUtils.getIdentityHexString(this);
            }
        }
        return this.id;
    }

    @Nullable
    protected String initId() {
        return null;
    }

    @Override
    public HttpMethod getMethod() {
        if (this.method != null) {
            return this.method;
        }
        throw new IllegalStateException("No HttpMethod provided in constructor, and AbstractServerHttpRequest::getMethod not overridden");
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public RequestPath getPath() {
        return this.path;
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public MultiValueMap<String, String> getQueryParams() {
        if (this.queryParams == null) {
            this.queryParams = CollectionUtils.unmodifiableMultiValueMap(this.initQueryParams());
        }
        return this.queryParams;
    }

    protected MultiValueMap<String, String> initQueryParams() {
        LinkedMultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        String query = this.getURI().getRawQuery();
        if (query != null) {
            Matcher matcher = QUERY_PATTERN.matcher(query);
            while (matcher.find()) {
                String name = this.decodeQueryParam(matcher.group(1));
                String eq = matcher.group(2);
                String value = matcher.group(3);
                value = value != null ? this.decodeQueryParam(value) : (StringUtils.hasLength(eq) ? "" : null);
                queryParams.add(name, value);
            }
        }
        return queryParams;
    }

    private String decodeQueryParam(String value) {
        return URLDecoder.decode(value, StandardCharsets.UTF_8);
    }

    @Override
    public MultiValueMap<String, HttpCookie> getCookies() {
        if (this.cookies == null) {
            this.cookies = CollectionUtils.unmodifiableMultiValueMap(this.initCookies());
        }
        return this.cookies;
    }

    protected abstract MultiValueMap<String, HttpCookie> initCookies();

    @Override
    @Nullable
    public SslInfo getSslInfo() {
        if (this.sslInfo == null) {
            this.sslInfo = this.initSslInfo();
        }
        return this.sslInfo;
    }

    @Nullable
    protected abstract SslInfo initSslInfo();

    public abstract <T> T getNativeRequest();

    String getLogPrefix() {
        if (this.logPrefix == null) {
            this.logPrefix = "[" + this.initLogPrefix() + "] ";
        }
        return this.logPrefix;
    }

    protected String initLogPrefix() {
        return this.getId();
    }
}

