/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web;

import jakarta.servlet.ServletException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpMethod;
import keycloakjar.org.springframework.http.HttpStatus;
import keycloakjar.org.springframework.http.HttpStatusCode;
import keycloakjar.org.springframework.http.ProblemDetail;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.ObjectUtils;
import keycloakjar.org.springframework.util.StringUtils;
import keycloakjar.org.springframework.web.ErrorResponse;

public class HttpRequestMethodNotSupportedException
extends ServletException
implements ErrorResponse {
    private final String method;
    @Nullable
    private final String[] supportedMethods;
    private final ProblemDetail body;

    public HttpRequestMethodNotSupportedException(String method) {
        this(method, (String[])null);
    }

    @Deprecated(since="6.0", forRemoval=true)
    public HttpRequestMethodNotSupportedException(String method, String msg) {
        this(method, null, msg);
    }

    public HttpRequestMethodNotSupportedException(String method, @Nullable Collection<String> supportedMethods) {
        this(method, supportedMethods != null ? StringUtils.toStringArray(supportedMethods) : null);
    }

    @Deprecated(since="6.0", forRemoval=true)
    public HttpRequestMethodNotSupportedException(String method, @Nullable String[] supportedMethods) {
        this(method, supportedMethods, "Request method '" + method + "' is not supported");
    }

    @Deprecated(since="6.0", forRemoval=true)
    public HttpRequestMethodNotSupportedException(String method, @Nullable String[] supportedMethods, String msg) {
        super(msg);
        this.method = method;
        this.supportedMethods = supportedMethods;
        String detail = "Method '" + method + "' is not supported.";
        this.body = ProblemDetail.forStatusAndDetail(this.getStatusCode(), detail);
    }

    public String getMethod() {
        return this.method;
    }

    @Nullable
    public String[] getSupportedMethods() {
        return this.supportedMethods;
    }

    @Nullable
    public Set<HttpMethod> getSupportedHttpMethods() {
        if (this.supportedMethods == null) {
            return null;
        }
        LinkedHashSet<HttpMethod> supportedMethods = new LinkedHashSet<HttpMethod>(this.supportedMethods.length);
        for (String value : this.supportedMethods) {
            HttpMethod method = HttpMethod.valueOf(value);
            supportedMethods.add(method);
        }
        return supportedMethods;
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return HttpStatus.METHOD_NOT_ALLOWED;
    }

    @Override
    public HttpHeaders getHeaders() {
        if (ObjectUtils.isEmpty(this.supportedMethods)) {
            return HttpHeaders.EMPTY;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Allow", StringUtils.arrayToDelimitedString(this.supportedMethods, ", "));
        return headers;
    }

    @Override
    public ProblemDetail getBody() {
        return this.body;
    }

    @Override
    public Object[] getDetailMessageArguments() {
        return new Object[]{this.getMethod(), this.getSupportedHttpMethods()};
    }
}

