/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.client;

import java.nio.charset.Charset;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpStatus;
import keycloakjar.org.springframework.http.HttpStatusCode;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.web.client.HttpStatusCodeException;

public class HttpClientErrorException
extends HttpStatusCodeException {
    private static final long serialVersionUID = 5177019431887513952L;

    public HttpClientErrorException(HttpStatusCode statusCode) {
        super(statusCode);
    }

    public HttpClientErrorException(HttpStatusCode statusCode, String statusText) {
        super(statusCode, statusText);
    }

    public HttpClientErrorException(HttpStatusCode statusCode, String statusText, @Nullable byte[] body, @Nullable Charset responseCharset) {
        super(statusCode, statusText, body, responseCharset);
    }

    public HttpClientErrorException(HttpStatusCode statusCode, String statusText, @Nullable HttpHeaders headers, @Nullable byte[] body, @Nullable Charset responseCharset) {
        super(statusCode, statusText, headers, body, responseCharset);
    }

    public HttpClientErrorException(String message, HttpStatusCode statusCode, String statusText, @Nullable HttpHeaders headers, @Nullable byte[] body, @Nullable Charset responseCharset) {
        super(message, statusCode, statusText, headers, body, responseCharset);
    }

    public static HttpClientErrorException create(HttpStatusCode statusCode, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
        return HttpClientErrorException.create(null, statusCode, statusText, headers, body, charset);
    }

    public static HttpClientErrorException create(@Nullable String message, HttpStatusCode statusCode, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
        if (statusCode instanceof HttpStatus) {
            HttpStatus status = (HttpStatus)statusCode;
            return switch (status) {
                case HttpStatus.BAD_REQUEST -> {
                    if (message != null) {
                        yield new BadRequest(message, statusText, headers, body, charset);
                    }
                    yield new BadRequest(statusText, headers, body, charset);
                }
                case HttpStatus.UNAUTHORIZED -> {
                    if (message != null) {
                        yield new Unauthorized(message, statusText, headers, body, charset);
                    }
                    yield new Unauthorized(statusText, headers, body, charset);
                }
                case HttpStatus.FORBIDDEN -> {
                    if (message != null) {
                        yield new Forbidden(message, statusText, headers, body, charset);
                    }
                    yield new Forbidden(statusText, headers, body, charset);
                }
                case HttpStatus.NOT_FOUND -> {
                    if (message != null) {
                        yield new NotFound(message, statusText, headers, body, charset);
                    }
                    yield new NotFound(statusText, headers, body, charset);
                }
                case HttpStatus.METHOD_NOT_ALLOWED -> {
                    if (message != null) {
                        yield new MethodNotAllowed(message, statusText, headers, body, charset);
                    }
                    yield new MethodNotAllowed(statusText, headers, body, charset);
                }
                case HttpStatus.NOT_ACCEPTABLE -> {
                    if (message != null) {
                        yield new NotAcceptable(message, statusText, headers, body, charset);
                    }
                    yield new NotAcceptable(statusText, headers, body, charset);
                }
                case HttpStatus.CONFLICT -> {
                    if (message != null) {
                        yield new Conflict(message, statusText, headers, body, charset);
                    }
                    yield new Conflict(statusText, headers, body, charset);
                }
                case HttpStatus.GONE -> {
                    if (message != null) {
                        yield new Gone(message, statusText, headers, body, charset);
                    }
                    yield new Gone(statusText, headers, body, charset);
                }
                case HttpStatus.UNSUPPORTED_MEDIA_TYPE -> {
                    if (message != null) {
                        yield new UnsupportedMediaType(message, statusText, headers, body, charset);
                    }
                    yield new UnsupportedMediaType(statusText, headers, body, charset);
                }
                case HttpStatus.TOO_MANY_REQUESTS -> {
                    if (message != null) {
                        yield new TooManyRequests(message, statusText, headers, body, charset);
                    }
                    yield new TooManyRequests(statusText, headers, body, charset);
                }
                case HttpStatus.UNPROCESSABLE_ENTITY -> {
                    if (message != null) {
                        yield new UnprocessableEntity(message, statusText, headers, body, charset);
                    }
                    yield new UnprocessableEntity(statusText, headers, body, charset);
                }
                default -> message != null ? new HttpClientErrorException(message, statusCode, statusText, headers, body, charset) : new HttpClientErrorException(statusCode, statusText, headers, body, charset);
            };
        }
        if (message != null) {
            return new HttpClientErrorException(message, statusCode, statusText, headers, body, charset);
        }
        return new HttpClientErrorException(statusCode, statusText, headers, body, charset);
    }

    public static final class BadRequest
    extends HttpClientErrorException {
        private BadRequest(String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(HttpStatus.BAD_REQUEST, statusText, headers, body, charset);
        }

        private BadRequest(String message, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(message, HttpStatus.BAD_REQUEST, statusText, headers, body, charset);
        }
    }

    public static final class Unauthorized
    extends HttpClientErrorException {
        private Unauthorized(String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(HttpStatus.UNAUTHORIZED, statusText, headers, body, charset);
        }

        private Unauthorized(String message, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(message, HttpStatus.UNAUTHORIZED, statusText, headers, body, charset);
        }
    }

    public static final class Forbidden
    extends HttpClientErrorException {
        private Forbidden(String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(HttpStatus.FORBIDDEN, statusText, headers, body, charset);
        }

        private Forbidden(String message, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(message, HttpStatus.FORBIDDEN, statusText, headers, body, charset);
        }
    }

    public static final class NotFound
    extends HttpClientErrorException {
        private NotFound(String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(HttpStatus.NOT_FOUND, statusText, headers, body, charset);
        }

        private NotFound(String message, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(message, HttpStatus.NOT_FOUND, statusText, headers, body, charset);
        }
    }

    public static final class MethodNotAllowed
    extends HttpClientErrorException {
        private MethodNotAllowed(String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(HttpStatus.METHOD_NOT_ALLOWED, statusText, headers, body, charset);
        }

        private MethodNotAllowed(String message, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(message, HttpStatus.METHOD_NOT_ALLOWED, statusText, headers, body, charset);
        }
    }

    public static final class NotAcceptable
    extends HttpClientErrorException {
        private NotAcceptable(String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(HttpStatus.NOT_ACCEPTABLE, statusText, headers, body, charset);
        }

        private NotAcceptable(String message, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(message, HttpStatus.NOT_ACCEPTABLE, statusText, headers, body, charset);
        }
    }

    public static final class Conflict
    extends HttpClientErrorException {
        private Conflict(String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(HttpStatus.CONFLICT, statusText, headers, body, charset);
        }

        private Conflict(String message, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(message, HttpStatus.CONFLICT, statusText, headers, body, charset);
        }
    }

    public static final class Gone
    extends HttpClientErrorException {
        private Gone(String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(HttpStatus.GONE, statusText, headers, body, charset);
        }

        private Gone(String message, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(message, HttpStatus.GONE, statusText, headers, body, charset);
        }
    }

    public static final class UnsupportedMediaType
    extends HttpClientErrorException {
        private UnsupportedMediaType(String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(HttpStatus.UNSUPPORTED_MEDIA_TYPE, statusText, headers, body, charset);
        }

        private UnsupportedMediaType(String message, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(message, HttpStatus.UNSUPPORTED_MEDIA_TYPE, statusText, headers, body, charset);
        }
    }

    public static final class TooManyRequests
    extends HttpClientErrorException {
        private TooManyRequests(String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(HttpStatus.TOO_MANY_REQUESTS, statusText, headers, body, charset);
        }

        private TooManyRequests(String message, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(message, HttpStatus.TOO_MANY_REQUESTS, statusText, headers, body, charset);
        }
    }

    public static final class UnprocessableEntity
    extends HttpClientErrorException {
        private UnprocessableEntity(String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(HttpStatus.UNPROCESSABLE_ENTITY, statusText, headers, body, charset);
        }

        private UnprocessableEntity(String message, String statusText, HttpHeaders headers, byte[] body, @Nullable Charset charset) {
            super(message, HttpStatus.UNPROCESSABLE_ENTITY, statusText, headers, body, charset);
        }
    }
}

