/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.context.support;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import keycloakjar.org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import keycloakjar.org.springframework.context.ApplicationContext;
import keycloakjar.org.springframework.context.support.AbstractRefreshableConfigApplicationContext;
import keycloakjar.org.springframework.core.env.ConfigurableEnvironment;
import keycloakjar.org.springframework.core.io.Resource;
import keycloakjar.org.springframework.core.io.ResourceLoader;
import keycloakjar.org.springframework.core.io.support.ResourcePatternResolver;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.ui.context.Theme;
import keycloakjar.org.springframework.ui.context.ThemeSource;
import keycloakjar.org.springframework.ui.context.support.UiApplicationContextUtils;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.web.context.ConfigurableWebApplicationContext;
import keycloakjar.org.springframework.web.context.ConfigurableWebEnvironment;
import keycloakjar.org.springframework.web.context.ServletConfigAware;
import keycloakjar.org.springframework.web.context.ServletContextAware;
import keycloakjar.org.springframework.web.context.support.ServletContextAwareProcessor;
import keycloakjar.org.springframework.web.context.support.ServletContextResource;
import keycloakjar.org.springframework.web.context.support.ServletContextResourcePatternResolver;
import keycloakjar.org.springframework.web.context.support.StandardServletEnvironment;
import keycloakjar.org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class AbstractRefreshableWebApplicationContext
extends AbstractRefreshableConfigApplicationContext
implements ConfigurableWebApplicationContext,
ThemeSource {
    @Nullable
    private ServletContext servletContext;
    @Nullable
    private ServletConfig servletConfig;
    @Nullable
    private String namespace;
    @Nullable
    private ThemeSource themeSource;

    public AbstractRefreshableWebApplicationContext() {
        this.setDisplayName("Root WebApplicationContext");
    }

    @Override
    public void setServletContext(@Nullable ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    @Nullable
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public void setServletConfig(@Nullable ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
        if (servletConfig != null && this.servletContext == null) {
            this.setServletContext(servletConfig.getServletContext());
        }
    }

    @Override
    @Nullable
    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    @Override
    public void setNamespace(@Nullable String namespace) {
        this.namespace = namespace;
        if (namespace != null) {
            this.setDisplayName("WebApplicationContext for namespace '" + namespace + "'");
        }
    }

    @Override
    @Nullable
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String[] getConfigLocations() {
        return super.getConfigLocations();
    }

    public String getApplicationName() {
        return this.servletContext != null ? this.servletContext.getContextPath() : "";
    }

    protected ConfigurableEnvironment createEnvironment() {
        return new StandardServletEnvironment();
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        beanFactory.addBeanPostProcessor(new ServletContextAwareProcessor(this.servletContext, this.servletConfig));
        beanFactory.ignoreDependencyInterface(ServletContextAware.class);
        beanFactory.ignoreDependencyInterface(ServletConfigAware.class);
        WebApplicationContextUtils.registerWebApplicationScopes(beanFactory, this.servletContext);
        WebApplicationContextUtils.registerEnvironmentBeans(beanFactory, this.servletContext, this.servletConfig);
    }

    protected Resource getResourceByPath(String path) {
        Assert.state(this.servletContext != null, "No ServletContext available");
        return new ServletContextResource(this.servletContext, path);
    }

    protected ResourcePatternResolver getResourcePatternResolver() {
        return new ServletContextResourcePatternResolver((ResourceLoader)((Object)this));
    }

    protected void onRefresh() {
        this.themeSource = UiApplicationContextUtils.initThemeSource((ApplicationContext)this);
    }

    protected void initPropertySources() {
        ConfigurableEnvironment env = this.getEnvironment();
        if (env instanceof ConfigurableWebEnvironment) {
            ConfigurableWebEnvironment configurableWebEnv = (ConfigurableWebEnvironment)env;
            configurableWebEnv.initPropertySources(this.servletContext, this.servletConfig);
        }
    }

    @Nullable
    @Deprecated
    public Theme getTheme(String themeName) {
        Assert.state(this.themeSource != null, "No ThemeSource available");
        return this.themeSource.getTheme(themeName);
    }
}

