/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.apache.hc.client5.http.ssl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import keycloakjar.org.apache.hc.client5.http.ssl.AbstractClientTlsStrategy;
import keycloakjar.org.apache.hc.client5.http.ssl.HttpsSupport;
import keycloakjar.org.apache.hc.core5.annotation.Contract;
import keycloakjar.org.apache.hc.core5.annotation.ThreadingBehavior;
import keycloakjar.org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import keycloakjar.org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import keycloakjar.org.apache.hc.core5.reactor.ssl.TlsDetails;
import keycloakjar.org.apache.hc.core5.ssl.SSLContexts;
import org.conscrypt.Conscrypt;

@Contract(threading=ThreadingBehavior.STATELESS)
public class ConscryptClientTlsStrategy
extends AbstractClientTlsStrategy {
    public static TlsStrategy getDefault() {
        return new ConscryptClientTlsStrategy(SSLContexts.createDefault(), HttpsSupport.getDefaultHostnameVerifier());
    }

    public static TlsStrategy getSystemDefault() {
        return new ConscryptClientTlsStrategy(SSLContexts.createSystemDefault(), HttpsSupport.getSystemProtocols(), HttpsSupport.getSystemCipherSuits(), SSLBufferMode.STATIC, HttpsSupport.getDefaultHostnameVerifier());
    }

    public ConscryptClientTlsStrategy(SSLContext sslContext, String[] supportedProtocols, String[] supportedCipherSuites, SSLBufferMode sslBufferManagement, HostnameVerifier hostnameVerifier) {
        super(sslContext, supportedProtocols, supportedCipherSuites, sslBufferManagement, hostnameVerifier);
    }

    public ConscryptClientTlsStrategy(SSLContext sslContext, HostnameVerifier hostnameVerifier) {
        this(sslContext, null, null, SSLBufferMode.STATIC, hostnameVerifier);
    }

    public ConscryptClientTlsStrategy(SSLContext sslContext) {
        this(sslContext, HttpsSupport.getDefaultHostnameVerifier());
    }

    @Override
    void applyParameters(SSLEngine sslEngine, SSLParameters sslParameters, String[] appProtocols) {
        if (Conscrypt.isConscrypt((SSLEngine)sslEngine)) {
            sslEngine.setSSLParameters(sslParameters);
            Conscrypt.setApplicationProtocols((SSLEngine)sslEngine, (String[])appProtocols);
        } else {
            sslParameters.setApplicationProtocols(appProtocols);
            sslEngine.setSSLParameters(sslParameters);
        }
    }

    @Override
    TlsDetails createTlsDetails(SSLEngine sslEngine) {
        if (Conscrypt.isConscrypt((SSLEngine)sslEngine)) {
            return new TlsDetails(sslEngine.getSession(), Conscrypt.getApplicationProtocol((SSLEngine)sslEngine));
        }
        return null;
    }

    public static boolean isSupported() {
        try {
            Class<?> clazz = Class.forName("org.conscrypt.Conscrypt");
            Method method = clazz.getMethod("isAvailable", new Class[0]);
            return (Boolean)method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return false;
        }
    }
}

