/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.aot.generate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import keycloakjar.org.springframework.aot.generate.GeneratedMethods;
import keycloakjar.org.springframework.aot.generate.UnsupportedTypeValueCodeGenerationException;
import keycloakjar.org.springframework.aot.generate.ValueCodeGenerationException;
import keycloakjar.org.springframework.aot.generate.ValueCodeGeneratorDelegates;
import keycloakjar.org.springframework.javapoet.CodeBlock;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;

public final class ValueCodeGenerator {
    private static final ValueCodeGenerator INSTANCE = new ValueCodeGenerator(ValueCodeGeneratorDelegates.INSTANCES, null);
    private static final CodeBlock NULL_VALUE_CODE_BLOCK = CodeBlock.of("null", new Object[0]);
    private final List<Delegate> delegates;
    @Nullable
    private final GeneratedMethods generatedMethods;

    private ValueCodeGenerator(List<Delegate> delegates, @Nullable GeneratedMethods generatedMethods) {
        this.delegates = delegates;
        this.generatedMethods = generatedMethods;
    }

    public static ValueCodeGenerator withDefaults() {
        return INSTANCE;
    }

    public static ValueCodeGenerator with(Delegate ... delegates) {
        return ValueCodeGenerator.with(Arrays.asList(delegates));
    }

    public static ValueCodeGenerator with(List<Delegate> delegates) {
        Assert.notEmpty(delegates, "Delegates must not be empty");
        return new ValueCodeGenerator(new ArrayList<Delegate>(delegates), null);
    }

    public ValueCodeGenerator add(List<Delegate> additionalDelegates) {
        Assert.notEmpty(additionalDelegates, "AdditionalDelegates must not be empty");
        ArrayList<Delegate> allDelegates = new ArrayList<Delegate>(this.delegates);
        allDelegates.addAll(additionalDelegates);
        return new ValueCodeGenerator(allDelegates, this.generatedMethods);
    }

    public ValueCodeGenerator scoped(GeneratedMethods generatedMethods) {
        return new ValueCodeGenerator(this.delegates, generatedMethods);
    }

    public CodeBlock generateCode(@Nullable Object value) {
        if (value == null) {
            return NULL_VALUE_CODE_BLOCK;
        }
        try {
            for (Delegate delegate : this.delegates) {
                CodeBlock code = delegate.generateCode(this, value);
                if (code == null) continue;
                return code;
            }
            throw new UnsupportedTypeValueCodeGenerationException(value);
        }
        catch (Exception ex) {
            throw new ValueCodeGenerationException(value, (Throwable)ex);
        }
    }

    @Nullable
    public GeneratedMethods getGeneratedMethods() {
        return this.generatedMethods;
    }

    public static interface Delegate {
        @Nullable
        public CodeBlock generateCode(ValueCodeGenerator var1, Object var2);
    }
}

