/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.beans.factory.config;

import keycloakjar.org.springframework.beans.factory.config.ConfigurableBeanFactory;
import keycloakjar.org.springframework.beans.factory.config.Scope;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;

public class BeanExpressionContext {
    private final ConfigurableBeanFactory beanFactory;
    @Nullable
    private final Scope scope;

    public BeanExpressionContext(ConfigurableBeanFactory beanFactory, @Nullable Scope scope) {
        Assert.notNull((Object)beanFactory, "BeanFactory must not be null");
        this.beanFactory = beanFactory;
        this.scope = scope;
    }

    public final ConfigurableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    @Nullable
    public final Scope getScope() {
        return this.scope;
    }

    public boolean containsObject(String key) {
        return this.beanFactory.containsBean(key) || this.scope != null && this.scope.resolveContextualObject(key) != null;
    }

    @Nullable
    public Object getObject(String key) {
        if (this.beanFactory.containsBean(key)) {
            return this.beanFactory.getBean(key);
        }
        if (this.scope != null) {
            return this.scope.resolveContextualObject(key);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof BeanExpressionContext)) return false;
        BeanExpressionContext that = (BeanExpressionContext)other;
        if (this.beanFactory != that.beanFactory) return false;
        if (this.scope != that.scope) return false;
        return true;
    }

    public int hashCode() {
        return this.beanFactory.hashCode();
    }
}

