/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.client;

import io.netty.channel.ChannelOption;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.function.Function;
import keycloakjar.org.apache.commons.logging.Log;
import keycloakjar.org.apache.commons.logging.LogFactory;
import keycloakjar.org.springframework.context.SmartLifecycle;
import keycloakjar.org.springframework.http.HttpMethod;
import keycloakjar.org.springframework.http.client.ClientHttpRequest;
import keycloakjar.org.springframework.http.client.ClientHttpRequestFactory;
import keycloakjar.org.springframework.http.client.ReactorNettyClientRequest;
import keycloakjar.org.springframework.http.client.ReactorResourceFactory;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;

public class ReactorNettyClientRequestFactory
implements ClientHttpRequestFactory,
SmartLifecycle {
    private static final Log logger = LogFactory.getLog(ReactorNettyClientRequestFactory.class);
    private static final Function<HttpClient, HttpClient> defaultInitializer = client -> client.compress(true);
    private HttpClient httpClient;
    @Nullable
    private final ReactorResourceFactory resourceFactory;
    @Nullable
    private final Function<HttpClient, HttpClient> mapper;
    private Duration exchangeTimeout = Duration.ofSeconds(5L);
    private Duration readTimeout = Duration.ofSeconds(10L);
    private volatile boolean running = true;
    private final Object lifecycleMonitor = new Object();

    public ReactorNettyClientRequestFactory() {
        this.httpClient = defaultInitializer.apply(HttpClient.create());
        this.resourceFactory = null;
        this.mapper = null;
    }

    public ReactorNettyClientRequestFactory(HttpClient httpClient) {
        Assert.notNull((Object)httpClient, "HttpClient must not be null");
        this.httpClient = httpClient;
        this.resourceFactory = null;
        this.mapper = null;
    }

    public ReactorNettyClientRequestFactory(ReactorResourceFactory resourceFactory, Function<HttpClient, HttpClient> mapper) {
        this.httpClient = ReactorNettyClientRequestFactory.createHttpClient(resourceFactory, mapper);
        this.resourceFactory = resourceFactory;
        this.mapper = mapper;
    }

    private static HttpClient createHttpClient(ReactorResourceFactory resourceFactory, Function<HttpClient, HttpClient> mapper) {
        ConnectionProvider provider = resourceFactory.getConnectionProvider();
        Assert.notNull((Object)provider, "No ConnectionProvider: is ReactorResourceFactory not initialized yet?");
        return defaultInitializer.andThen(mapper).andThen(ReactorNettyClientRequestFactory.applyLoopResources(resourceFactory)).apply(HttpClient.create((ConnectionProvider)provider));
    }

    private static Function<HttpClient, HttpClient> applyLoopResources(ReactorResourceFactory factory) {
        return httpClient -> {
            LoopResources resources = factory.getLoopResources();
            Assert.notNull((Object)resources, "No LoopResources: is ReactorResourceFactory not initialized yet?");
            return (HttpClient)httpClient.runOn(resources);
        };
    }

    public void setConnectTimeout(int connectTimeout) {
        Assert.isTrue(connectTimeout >= 0, "Timeout must be a non-negative value");
        this.httpClient.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeout);
    }

    public void setConnectTimeout(Duration connectTimeout) {
        Assert.notNull((Object)connectTimeout, "ConnectTimeout must not be null");
        Assert.isTrue(!connectTimeout.isNegative(), "Timeout must be a non-negative value");
        this.httpClient.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)connectTimeout.toMillis()));
    }

    public void setReadTimeout(long readTimeout) {
        Assert.isTrue(readTimeout > 0L, "Timeout must be a positive value");
        this.readTimeout = Duration.ofMillis(readTimeout);
    }

    public void setReadTimeout(Duration readTimeout) {
        Assert.notNull((Object)readTimeout, "ReadTimeout must not be null");
        Assert.isTrue(!readTimeout.isNegative(), "Timeout must be a non-negative value");
        this.readTimeout = readTimeout;
    }

    public void setExchangeTimeout(long exchangeTimeout) {
        Assert.isTrue(exchangeTimeout > 0L, "Timeout must be a positive value");
        this.exchangeTimeout = Duration.ofMillis(exchangeTimeout);
    }

    public void setExchangeTimeout(Duration exchangeTimeout) {
        Assert.notNull((Object)exchangeTimeout, "ExchangeTimeout must not be null");
        Assert.isTrue(!exchangeTimeout.isNegative(), "Timeout must be a non-negative value");
        this.exchangeTimeout = exchangeTimeout;
    }

    @Override
    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        return new ReactorNettyClientRequest(this.httpClient, uri, httpMethod, this.exchangeTimeout, this.readTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.isRunning()) {
                if (this.resourceFactory != null && this.mapper != null) {
                    this.httpClient = ReactorNettyClientRequestFactory.createHttpClient(this.resourceFactory, this.mapper);
                } else {
                    logger.warn("Restarting a ReactorNettyClientRequestFactory bean is only supported with externally managed Reactor Netty resources");
                }
                this.running = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.isRunning()) {
                this.running = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(Runnable callback) {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.stop();
            callback.run();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isAutoStartup() {
        return false;
    }

    public int getPhase() {
        return 1;
    }
}

