/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpStatusCode;
import keycloakjar.org.springframework.http.client.ClientHttpResponse;
import keycloakjar.org.springframework.http.support.Netty4HeadersAdapter;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.StreamUtils;
import reactor.netty.Connection;
import reactor.netty.http.client.HttpClientResponse;

final class ReactorNettyClientResponse
implements ClientHttpResponse {
    private final HttpClientResponse response;
    private final Connection connection;
    private final HttpHeaders headers;
    private final Duration readTimeout;
    @Nullable
    private volatile InputStream body;

    public ReactorNettyClientResponse(HttpClientResponse response, Connection connection, Duration readTimeout) {
        this.response = response;
        this.connection = connection;
        this.readTimeout = readTimeout;
        this.headers = HttpHeaders.readOnlyHttpHeaders(new Netty4HeadersAdapter(response.responseHeaders()));
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return HttpStatusCode.valueOf(this.response.status().code());
    }

    @Override
    public String getStatusText() {
        return this.response.status().reasonPhrase();
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public InputStream getBody() throws IOException {
        InputStream body2 = this.body;
        if (body2 != null) {
            return body2;
        }
        body2 = (InputStream)this.connection.inbound().receive().aggregate().asInputStream().block(this.readTimeout);
        if (body2 == null) {
            throw new IOException("Could not receive body");
        }
        this.body = body2;
        return body2;
    }

    @Override
    public void close() {
        try {
            InputStream body2 = this.getBody();
            StreamUtils.drain(body2);
            body2.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

