/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.server.reactive;

import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLSession;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.core.io.buffer.DataBufferFactory;
import keycloakjar.org.springframework.http.HttpCookie;
import keycloakjar.org.springframework.http.HttpMethod;
import keycloakjar.org.springframework.http.server.reactive.AbstractListenerReadPublisher;
import keycloakjar.org.springframework.http.server.reactive.AbstractServerHttpRequest;
import keycloakjar.org.springframework.http.server.reactive.DefaultSslInfo;
import keycloakjar.org.springframework.http.server.reactive.SslInfo;
import keycloakjar.org.springframework.http.server.reactive.UndertowHeadersAdapter;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.LinkedMultiValueMap;
import keycloakjar.org.springframework.util.MultiValueMap;
import keycloakjar.org.springframework.util.ObjectUtils;
import keycloakjar.org.springframework.util.StringUtils;
import org.reactivestreams.Publisher;
import org.xnio.channels.StreamSourceChannel;
import reactor.core.publisher.Flux;

class UndertowServerHttpRequest
extends AbstractServerHttpRequest {
    private static final AtomicLong logPrefixIndex = new AtomicLong();
    private final HttpServerExchange exchange;
    private final RequestBodyPublisher body;

    public UndertowServerHttpRequest(HttpServerExchange exchange2, DataBufferFactory bufferFactory) throws URISyntaxException {
        super(HttpMethod.valueOf(exchange2.getRequestMethod().toString()), UndertowServerHttpRequest.initUri(exchange2), "", new UndertowHeadersAdapter(exchange2.getRequestHeaders()));
        this.exchange = exchange2;
        this.body = new RequestBodyPublisher(exchange2, bufferFactory);
        this.body.registerListeners(exchange2);
    }

    private static URI initUri(HttpServerExchange exchange2) throws URISyntaxException {
        Assert.notNull((Object)exchange2, "HttpServerExchange is required");
        String requestURL = exchange2.getRequestURL();
        String query = exchange2.getQueryString();
        String requestUriAndQuery = StringUtils.hasLength(query) ? requestURL + "?" + query : requestURL;
        return new URI(requestUriAndQuery);
    }

    @Override
    protected MultiValueMap<String, HttpCookie> initCookies() {
        LinkedMultiValueMap<String, HttpCookie> cookies = new LinkedMultiValueMap<String, HttpCookie>();
        for (Cookie cookie : this.exchange.requestCookies()) {
            HttpCookie httpCookie = new HttpCookie(cookie.getName(), cookie.getValue());
            cookies.add(cookie.getName(), httpCookie);
        }
        return cookies;
    }

    @Override
    @Nullable
    public InetSocketAddress getLocalAddress() {
        return this.exchange.getDestinationAddress();
    }

    @Override
    @Nullable
    public InetSocketAddress getRemoteAddress() {
        return this.exchange.getSourceAddress();
    }

    @Override
    @Nullable
    protected SslInfo initSslInfo() {
        SSLSession session = this.exchange.getConnection().getSslSession();
        if (session != null) {
            return new DefaultSslInfo(session);
        }
        return null;
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return Flux.from((Publisher)this.body);
    }

    @Override
    public <T> T getNativeRequest() {
        return (T)this.exchange;
    }

    @Override
    protected String initId() {
        return ObjectUtils.getIdentityHexString(this.exchange.getConnection()) + "-" + logPrefixIndex.incrementAndGet();
    }

    private class RequestBodyPublisher
    extends AbstractListenerReadPublisher<DataBuffer> {
        private final StreamSourceChannel channel;
        private final DataBufferFactory bufferFactory;
        private final ByteBufferPool byteBufferPool;

        public RequestBodyPublisher(HttpServerExchange exchange2, DataBufferFactory bufferFactory) {
            super(UndertowServerHttpRequest.this.getLogPrefix());
            this.channel = exchange2.getRequestChannel();
            this.bufferFactory = bufferFactory;
            this.byteBufferPool = exchange2.getConnection().getByteBufferPool();
        }

        private void registerListeners(HttpServerExchange exchange2) {
            exchange2.addExchangeCompleteListener((ex, next) -> {
                this.onAllDataRead();
                next.proceed();
            });
            this.channel.getReadSetter().set(c -> this.onDataAvailable());
            this.channel.getCloseSetter().set(c -> this.onAllDataRead());
            this.channel.resumeReads();
        }

        @Override
        protected void checkOnDataAvailable() {
            this.channel.resumeReads();
            this.onDataAvailable();
        }

        @Override
        protected void readingPaused() {
            this.channel.suspendReads();
        }

        @Override
        @Nullable
        protected DataBuffer read() throws IOException {
            PooledByteBuffer pooledByteBuffer;
            try (PooledByteBuffer pooledByteBuffer2 = pooledByteBuffer = this.byteBufferPool.allocate();){
                ByteBuffer byteBuffer = pooledByteBuffer.getBuffer();
                int read = this.channel.read(byteBuffer);
                if (rsReadLogger.isTraceEnabled()) {
                    rsReadLogger.trace(this.getLogPrefix() + "Read " + read + (read != -1 ? " bytes" : ""));
                }
                if (read > 0) {
                    byteBuffer.flip();
                    DataBuffer dataBuffer = this.bufferFactory.allocateBuffer(read);
                    dataBuffer.write(byteBuffer);
                    DataBuffer dataBuffer2 = dataBuffer;
                    return dataBuffer2;
                }
                if (read == -1) {
                    this.onAllDataRead();
                }
                DataBuffer dataBuffer = null;
                return dataBuffer;
            }
        }

        @Override
        protected void discardData() {
        }
    }
}

