/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.util;

import java.util.Set;
import keycloakjar.org.apache.commons.logging.Log;
import keycloakjar.org.apache.commons.logging.LogFactory;
import keycloakjar.org.springframework.core.NestedExceptionUtils;
import keycloakjar.org.springframework.util.Assert;

public class DisconnectedClientHelper {
    private static final Set<String> EXCEPTION_PHRASES = Set.of("broken pipe", "connection reset by peer");
    private static final Set<String> EXCEPTION_TYPE_NAMES = Set.of("AbortedException", "ClientAbortException", "EOFException", "EofException", "AsyncRequestNotUsableException");
    private final Log logger;

    public DisconnectedClientHelper(String logCategory) {
        Assert.notNull((Object)logCategory, "'logCategory' is required");
        this.logger = LogFactory.getLog(logCategory);
    }

    public boolean checkAndLogClientDisconnectedException(Throwable ex) {
        if (DisconnectedClientHelper.isClientDisconnectedException(ex)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Looks like the client has gone away", ex);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("Looks like the client has gone away: " + ex + " (For a full stack trace, set the log category '" + this.logger + "' to TRACE level.)");
            }
            return true;
        }
        return false;
    }

    public static boolean isClientDisconnectedException(Throwable ex) {
        String message = NestedExceptionUtils.getMostSpecificCause(ex).getMessage();
        if (message != null) {
            String text = message.toLowerCase();
            for (String phrase : EXCEPTION_PHRASES) {
                if (!text.contains(phrase)) continue;
                return true;
            }
        }
        return EXCEPTION_TYPE_NAMES.contains(ex.getClass().getSimpleName());
    }
}

