/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.apache.hc.core5.http2.protocol;

import java.io.IOException;
import keycloakjar.org.apache.hc.core5.annotation.Contract;
import keycloakjar.org.apache.hc.core5.annotation.ThreadingBehavior;
import keycloakjar.org.apache.hc.core5.http.EntityDetails;
import keycloakjar.org.apache.hc.core5.http.HttpException;
import keycloakjar.org.apache.hc.core5.http.HttpResponse;
import keycloakjar.org.apache.hc.core5.http.ProtocolVersion;
import keycloakjar.org.apache.hc.core5.http.message.MessageSupport;
import keycloakjar.org.apache.hc.core5.http.protocol.HttpContext;
import keycloakjar.org.apache.hc.core5.http.protocol.ResponseContent;
import keycloakjar.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class H2ResponseContent
extends ResponseContent {
    public static final H2ResponseContent INSTANCE = new H2ResponseContent();

    public H2ResponseContent() {
    }

    public H2ResponseContent(boolean overwrite) {
        super(overwrite);
    }

    @Override
    public void process(HttpResponse response, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(context, "HTTP context");
        ProtocolVersion ver = context.getProtocolVersion();
        if (ver.getMajor() < 2) {
            super.process(response, entity, context);
        } else if (entity != null) {
            MessageSupport.addContentTypeHeader(response, entity);
            MessageSupport.addContentEncodingHeader(response, entity);
            MessageSupport.addTrailerHeader(response, entity);
        }
    }
}

