/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.beans.factory.aot;

import java.lang.reflect.Type;
import java.util.List;
import javax.lang.model.element.Modifier;
import keycloakjar.org.springframework.aot.generate.GeneratedClass;
import keycloakjar.org.springframework.aot.generate.GeneratedMethod;
import keycloakjar.org.springframework.aot.generate.GeneratedMethods;
import keycloakjar.org.springframework.aot.generate.GenerationContext;
import keycloakjar.org.springframework.aot.generate.MethodReference;
import keycloakjar.org.springframework.beans.factory.aot.BeanDefinitionMethodGeneratorFactory;
import keycloakjar.org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import keycloakjar.org.springframework.beans.factory.aot.BeanRegistrationCodeFragments;
import keycloakjar.org.springframework.beans.factory.aot.BeanRegistrationCodeGenerator;
import keycloakjar.org.springframework.beans.factory.aot.BeanRegistrationsCode;
import keycloakjar.org.springframework.beans.factory.aot.CodeWarnings;
import keycloakjar.org.springframework.beans.factory.aot.DefaultBeanRegistrationCodeFragments;
import keycloakjar.org.springframework.beans.factory.config.BeanDefinition;
import keycloakjar.org.springframework.beans.factory.support.RegisteredBean;
import keycloakjar.org.springframework.javapoet.ClassName;
import keycloakjar.org.springframework.javapoet.MethodSpec;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.StringUtils;

class BeanDefinitionMethodGenerator {
    private final BeanDefinitionMethodGeneratorFactory methodGeneratorFactory;
    private final RegisteredBean registeredBean;
    @Nullable
    private final String currentPropertyName;
    private final List<BeanRegistrationAotContribution> aotContributions;

    BeanDefinitionMethodGenerator(BeanDefinitionMethodGeneratorFactory methodGeneratorFactory, RegisteredBean registeredBean, @Nullable String currentPropertyName, List<BeanRegistrationAotContribution> aotContributions) {
        this.methodGeneratorFactory = methodGeneratorFactory;
        this.registeredBean = registeredBean;
        this.currentPropertyName = currentPropertyName;
        this.aotContributions = aotContributions;
    }

    MethodReference generateBeanDefinitionMethod(GenerationContext generationContext, BeanRegistrationsCode beanRegistrationsCode) {
        BeanRegistrationCodeFragments codeFragments = this.getCodeFragments(generationContext, beanRegistrationsCode);
        ClassName target = codeFragments.getTarget(this.registeredBean);
        if (this.isWritablePackageName(target)) {
            GeneratedClass generatedClass = BeanDefinitionMethodGenerator.lookupGeneratedClass(generationContext, target);
            GeneratedMethods generatedMethods = generatedClass.getMethods().withPrefix(this.getName());
            GeneratedMethod generatedMethod = this.generateBeanDefinitionMethod(generationContext, generatedClass.getName(), generatedMethods, codeFragments, Modifier.PUBLIC);
            return generatedMethod.toMethodReference();
        }
        GeneratedMethods generatedMethods = beanRegistrationsCode.getMethods().withPrefix(this.getName());
        GeneratedMethod generatedMethod = this.generateBeanDefinitionMethod(generationContext, beanRegistrationsCode.getClassName(), generatedMethods, codeFragments, Modifier.PRIVATE);
        return generatedMethod.toMethodReference();
    }

    private boolean isWritablePackageName(ClassName target) {
        String packageName = target.packageName();
        return !packageName.startsWith("java.") && !packageName.startsWith("javax.");
    }

    private static GeneratedClass lookupGeneratedClass(GenerationContext generationContext, ClassName target) {
        ClassName topLevelClassName = target.topLevelClassName();
        GeneratedClass generatedClass = generationContext.getGeneratedClasses().getOrAddForFeatureComponent("BeanDefinitions", topLevelClassName, type -> {
            type.addJavadoc("Bean definitions for {@link $T}.", topLevelClassName);
            type.addModifiers(Modifier.PUBLIC);
        });
        List<String> names = target.simpleNames();
        if (names.size() == 1) {
            return generatedClass;
        }
        List<String> namesToProcess = names.subList(1, names.size());
        ClassName currentTargetClassName = topLevelClassName;
        GeneratedClass tmp = generatedClass;
        for (String nameToProcess : namesToProcess) {
            currentTargetClassName = currentTargetClassName.nestedClass(nameToProcess);
            tmp = BeanDefinitionMethodGenerator.createInnerClass(tmp, nameToProcess, currentTargetClassName);
        }
        return tmp;
    }

    private static GeneratedClass createInnerClass(GeneratedClass generatedClass, String name, ClassName target) {
        return generatedClass.getOrAdd(name, type -> {
            type.addJavadoc("Bean definitions for {@link $T}.", target);
            type.addModifiers(Modifier.PUBLIC, Modifier.STATIC);
        });
    }

    private BeanRegistrationCodeFragments getCodeFragments(GenerationContext generationContext, BeanRegistrationsCode beanRegistrationsCode) {
        BeanRegistrationCodeFragments codeFragments = new DefaultBeanRegistrationCodeFragments(beanRegistrationsCode, this.registeredBean, this.methodGeneratorFactory);
        for (BeanRegistrationAotContribution aotContribution : this.aotContributions) {
            codeFragments = aotContribution.customizeBeanRegistrationCodeFragments(generationContext, codeFragments);
        }
        return codeFragments;
    }

    private GeneratedMethod generateBeanDefinitionMethod(GenerationContext generationContext, ClassName className, GeneratedMethods generatedMethods, BeanRegistrationCodeFragments codeFragments, Modifier modifier) {
        BeanRegistrationCodeGenerator codeGenerator = new BeanRegistrationCodeGenerator(className, generatedMethods, this.registeredBean, codeFragments);
        this.aotContributions.forEach(aotContribution -> aotContribution.applyTo(generationContext, codeGenerator));
        CodeWarnings codeWarnings = new CodeWarnings();
        codeWarnings.detectDeprecation(this.registeredBean.getBeanClass());
        return generatedMethods.add("getBeanDefinition", method -> {
            method.addJavadoc("Get the $L definition for '$L'.", this.registeredBean.isInnerBean() ? "inner-bean" : "bean", this.getName());
            method.addModifiers(modifier, Modifier.STATIC);
            codeWarnings.suppress((MethodSpec.Builder)method);
            method.returns((Type)((Object)BeanDefinition.class));
            method.addCode(codeGenerator.generateCode(generationContext));
        });
    }

    private String getName() {
        RegisteredBean nonGeneratedParent;
        if (this.currentPropertyName != null) {
            return this.currentPropertyName;
        }
        if (!this.registeredBean.isGeneratedBeanName()) {
            return this.getSimpleBeanName(this.registeredBean.getBeanName());
        }
        for (nonGeneratedParent = this.registeredBean; nonGeneratedParent != null && nonGeneratedParent.isGeneratedBeanName(); nonGeneratedParent = nonGeneratedParent.getParent()) {
        }
        if (nonGeneratedParent != null) {
            return this.getSimpleBeanName(nonGeneratedParent.getBeanName()) + "InnerBean";
        }
        return "innerBean";
    }

    private String getSimpleBeanName(String beanName) {
        int lastDot = beanName.lastIndexOf(46);
        beanName = lastDot != -1 ? beanName.substring(lastDot + 1) : beanName;
        int lastDollar = beanName.lastIndexOf(36);
        beanName = lastDollar != -1 ? beanName.substring(lastDollar + 1) : beanName;
        return StringUtils.uncapitalize(beanName);
    }
}

