/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.beans.factory.aot;

import java.lang.reflect.AnnotatedElement;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Stream;
import keycloakjar.org.springframework.javapoet.AnnotationSpec;
import keycloakjar.org.springframework.javapoet.CodeBlock;
import keycloakjar.org.springframework.javapoet.MethodSpec;
import keycloakjar.org.springframework.lang.Nullable;

class CodeWarnings {
    private final Set<String> warnings = new LinkedHashSet<String>();

    CodeWarnings() {
    }

    public void register(String warning) {
        this.warnings.add(warning);
    }

    public CodeWarnings detectDeprecation(AnnotatedElement ... elements) {
        for (AnnotatedElement element : elements) {
            this.register(element.getAnnotation(Deprecated.class));
        }
        return this;
    }

    public CodeWarnings detectDeprecation(Stream<AnnotatedElement> elements) {
        elements.forEach(element -> this.register(element.getAnnotation(Deprecated.class)));
        return this;
    }

    public void suppress(MethodSpec.Builder method) {
        if (this.warnings.isEmpty()) {
            return;
        }
        method.addAnnotation(this.buildAnnotationSpec());
    }

    protected Set<String> getWarnings() {
        return Collections.unmodifiableSet(this.warnings);
    }

    private void register(@Nullable Deprecated annotation) {
        if (annotation != null) {
            if (annotation.forRemoval()) {
                this.register("removal");
            } else {
                this.register("deprecation");
            }
        }
    }

    private AnnotationSpec buildAnnotationSpec() {
        return AnnotationSpec.builder(SuppressWarnings.class).addMember("value", this.generateValueCode()).build();
    }

    private CodeBlock generateValueCode() {
        if (this.warnings.size() == 1) {
            return CodeBlock.of("$S", this.warnings.iterator().next());
        }
        CodeBlock values = CodeBlock.join(this.warnings.stream().map(warning -> CodeBlock.of("$S", warning)).toList(), ", ");
        return CodeBlock.of("{ $L }", values);
    }

    public String toString() {
        return new StringJoiner(", ", CodeWarnings.class.getSimpleName(), "").add(this.warnings.toString()).toString();
    }
}

