/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.client.reactive;

import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import keycloakjar.org.apache.commons.logging.Log;
import keycloakjar.org.apache.commons.logging.LogFactory;
import keycloakjar.org.springframework.context.SmartLifecycle;
import keycloakjar.org.springframework.http.HttpMethod;
import keycloakjar.org.springframework.http.client.ReactorResourceFactory;
import keycloakjar.org.springframework.http.client.reactive.ClientHttpConnector;
import keycloakjar.org.springframework.http.client.reactive.ClientHttpRequest;
import keycloakjar.org.springframework.http.client.reactive.ClientHttpResponse;
import keycloakjar.org.springframework.http.client.reactive.ReactorClientHttpRequest;
import keycloakjar.org.springframework.http.client.reactive.ReactorClientHttpResponse;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.NettyOutbound;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.client.HttpClientResponse;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;

public class ReactorClientHttpConnector
implements ClientHttpConnector,
SmartLifecycle {
    private static final Log logger = LogFactory.getLog(ReactorClientHttpConnector.class);
    private static final Function<HttpClient, HttpClient> defaultInitializer = client -> client.compress(true);
    private HttpClient httpClient;
    @Nullable
    private final ReactorResourceFactory resourceFactory;
    @Nullable
    private final Function<HttpClient, HttpClient> mapper;
    private volatile boolean running = true;
    private final Object lifecycleMonitor = new Object();

    public ReactorClientHttpConnector() {
        this.httpClient = defaultInitializer.apply(HttpClient.create());
        this.resourceFactory = null;
        this.mapper = null;
    }

    public ReactorClientHttpConnector(ReactorResourceFactory resourceFactory, Function<HttpClient, HttpClient> mapper) {
        this.httpClient = ReactorClientHttpConnector.createHttpClient(resourceFactory, mapper);
        this.resourceFactory = resourceFactory;
        this.mapper = mapper;
    }

    private static HttpClient createHttpClient(ReactorResourceFactory resourceFactory, Function<HttpClient, HttpClient> mapper) {
        ConnectionProvider provider = resourceFactory.getConnectionProvider();
        Assert.notNull((Object)provider, "No ConnectionProvider: is ReactorResourceFactory not initialized yet?");
        return defaultInitializer.andThen(mapper).andThen(ReactorClientHttpConnector.applyLoopResources(resourceFactory)).apply(HttpClient.create((ConnectionProvider)provider));
    }

    private static Function<HttpClient, HttpClient> applyLoopResources(ReactorResourceFactory factory) {
        return httpClient -> {
            LoopResources resources = factory.getLoopResources();
            Assert.notNull((Object)resources, "No LoopResources: is ReactorResourceFactory not initialized yet?");
            return (HttpClient)httpClient.runOn(resources);
        };
    }

    public ReactorClientHttpConnector(HttpClient httpClient) {
        Assert.notNull((Object)httpClient, "HttpClient is required");
        this.httpClient = httpClient;
        this.resourceFactory = null;
        this.mapper = null;
    }

    @Override
    public Mono<ClientHttpResponse> connect(HttpMethod method, URI uri, Function<? super ClientHttpRequest, Mono<Void>> requestCallback) {
        AtomicReference responseRef = new AtomicReference();
        HttpClient.RequestSender requestSender = this.httpClient.request(io.netty.handler.codec.http.HttpMethod.valueOf((String)method.name()));
        requestSender = ReactorClientHttpConnector.setUri(requestSender, uri);
        return requestSender.send((request, outbound) -> (Publisher)requestCallback.apply(this.adaptRequest(method, uri, (HttpClientRequest)request, (NettyOutbound)outbound))).responseConnection((response, connection) -> {
            responseRef.set(new ReactorClientHttpResponse((HttpClientResponse)response, (Connection)connection));
            return Mono.just((Object)((ClientHttpResponse)responseRef.get()));
        }).next().doOnCancel(() -> {
            ReactorClientHttpResponse response = (ReactorClientHttpResponse)responseRef.get();
            if (response != null) {
                response.releaseAfterCancel(method);
            }
        });
    }

    private static HttpClient.RequestSender setUri(HttpClient.RequestSender requestSender, URI uri) {
        if (uri.isAbsolute()) {
            try {
                return (HttpClient.RequestSender)requestSender.uri(uri);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (HttpClient.RequestSender)requestSender.uri(uri.toString());
    }

    private ReactorClientHttpRequest adaptRequest(HttpMethod method, URI uri, HttpClientRequest request, NettyOutbound nettyOutbound) {
        return new ReactorClientHttpRequest(method, uri, request, nettyOutbound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.isRunning()) {
                if (this.resourceFactory != null && this.mapper != null) {
                    this.httpClient = ReactorClientHttpConnector.createHttpClient(this.resourceFactory, this.mapper);
                } else {
                    logger.warn("Restarting a ReactorClientHttpConnector bean is only supported with externally managed Reactor Netty resources");
                }
                this.running = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.isRunning()) {
                this.running = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(Runnable callback) {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.stop();
            callback.run();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isAutoStartup() {
        return false;
    }

    public int getPhase() {
        return 1;
    }
}

