/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.codec.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import keycloakjar.org.springframework.core.ResolvableType;
import keycloakjar.org.springframework.core.codec.CharBufferDecoder;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.core.io.buffer.DefaultDataBufferFactory;
import keycloakjar.org.springframework.http.codec.json.AbstractJackson2Decoder;
import keycloakjar.org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.MimeType;
import keycloakjar.org.springframework.util.MimeTypeUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class Jackson2JsonDecoder
extends AbstractJackson2Decoder {
    private static final CharBufferDecoder CHAR_BUFFER_DECODER = CharBufferDecoder.textPlainOnly(Arrays.asList(",", "\n"), false);
    private static final ResolvableType CHAR_BUFFER_TYPE = ResolvableType.forClass(CharBuffer.class);

    public Jackson2JsonDecoder() {
        super((ObjectMapper)Jackson2ObjectMapperBuilder.json().build(), new MimeType[0]);
    }

    public Jackson2JsonDecoder(ObjectMapper mapper, MimeType ... mimeTypes) {
        super(mapper, mimeTypes);
    }

    @Override
    protected Flux<DataBuffer> processInput(Publisher<DataBuffer> input, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        Flux flux = Flux.from(input);
        if (mimeType == null) {
            return flux;
        }
        Charset charset = mimeType.getCharset();
        if (charset == null || StandardCharsets.UTF_8.equals(charset) || StandardCharsets.US_ASCII.equals(charset)) {
            return flux;
        }
        MimeType textMimeType = new MimeType(MimeTypeUtils.TEXT_PLAIN, charset);
        Flux decoded = CHAR_BUFFER_DECODER.decode(input, CHAR_BUFFER_TYPE, textMimeType, null);
        return decoded.map(charBuffer -> DefaultDataBufferFactory.sharedInstance.wrap(StandardCharsets.UTF_8.encode((CharBuffer)charBuffer)));
    }
}

