/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.codec.multipart;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import keycloakjar.org.springframework.core.ResolvableType;
import keycloakjar.org.springframework.core.codec.Hints;
import keycloakjar.org.springframework.core.log.LogFormatUtils;
import keycloakjar.org.springframework.http.MediaType;
import keycloakjar.org.springframework.http.ReactiveHttpInputMessage;
import keycloakjar.org.springframework.http.codec.HttpMessageReader;
import keycloakjar.org.springframework.http.codec.LoggingCodecSupport;
import keycloakjar.org.springframework.http.codec.multipart.Part;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.LinkedMultiValueMap;
import keycloakjar.org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MultipartHttpMessageReader
extends LoggingCodecSupport
implements HttpMessageReader<MultiValueMap<String, Part>> {
    private static final ResolvableType MULTIPART_VALUE_TYPE = ResolvableType.forClassWithGenerics(MultiValueMap.class, String.class, Part.class);
    static final List<MediaType> MIME_TYPES = List.of(MediaType.MULTIPART_FORM_DATA, MediaType.MULTIPART_MIXED, MediaType.MULTIPART_RELATED);
    private final HttpMessageReader<Part> partReader;

    public MultipartHttpMessageReader(HttpMessageReader<Part> partReader) {
        Assert.notNull(partReader, "'partReader' is required");
        this.partReader = partReader;
    }

    public HttpMessageReader<Part> getPartReader() {
        return this.partReader;
    }

    @Override
    public List<MediaType> getReadableMediaTypes() {
        return MIME_TYPES;
    }

    @Override
    public boolean canRead(ResolvableType elementType, @Nullable MediaType mediaType) {
        return this.supportsMediaType(mediaType) && MULTIPART_VALUE_TYPE.isAssignableFrom(elementType);
    }

    private boolean supportsMediaType(@Nullable MediaType mediaType) {
        if (mediaType == null) {
            return true;
        }
        for (MediaType supportedMediaType : MIME_TYPES) {
            if (!supportedMediaType.isCompatibleWith(mediaType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Flux<MultiValueMap<String, Part>> read(ResolvableType elementType, ReactiveHttpInputMessage message, Map<String, Object> hints) {
        return Flux.from(this.readMono(elementType, message, hints));
    }

    @Override
    public Mono<MultiValueMap<String, Part>> readMono(ResolvableType elementType, ReactiveHttpInputMessage inputMessage, Map<String, Object> hints) {
        Map<String, Object> allHints = Hints.merge(hints, Hints.SUPPRESS_LOGGING_HINT, true);
        return this.partReader.read(elementType, inputMessage, allHints).collectMultimap(Part::name).doOnNext(map -> LogFormatUtils.traceDebug(this.logger, traceOn -> Hints.getLogPrefix(hints) + "Parsed " + (String)(this.isEnableLoggingRequestDetails() ? LogFormatUtils.formatValue(map, traceOn == false) : "parts " + map.keySet() + " (content masked)"))).map(this::toMultiValueMap);
    }

    private LinkedMultiValueMap<String, Part> toMultiValueMap(Map<String, Collection<Part>> map) {
        return new LinkedMultiValueMap<String, Part>(map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.toList((Collection)e.getValue()))));
    }

    private List<Part> toList(Collection<Part> collection) {
        List<Part> list;
        if (collection instanceof List) {
            List list2 = (List)collection;
            list = list2;
        } else {
            list = new ArrayList<Part>(collection);
        }
        return list;
    }
}

