/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.converter.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpInputMessage;
import keycloakjar.org.springframework.http.HttpOutputMessage;
import keycloakjar.org.springframework.http.MediaType;
import keycloakjar.org.springframework.http.converter.AbstractHttpMessageConverter;
import keycloakjar.org.springframework.http.converter.HttpMessageConversionException;
import keycloakjar.org.springframework.http.converter.HttpMessageNotReadableException;
import keycloakjar.org.springframework.http.converter.HttpMessageNotWritableException;
import keycloakjar.org.springframework.util.StreamUtils;

public abstract class AbstractXmlHttpMessageConverter<T>
extends AbstractHttpMessageConverter<T> {
    private final TransformerFactory transformerFactory = TransformerFactory.newInstance();

    protected AbstractXmlHttpMessageConverter() {
        super(MediaType.APPLICATION_XML, MediaType.TEXT_XML, new MediaType("application", "*+xml"));
    }

    @Override
    public final T readInternal(Class<? extends T> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        try {
            InputStream inputStream = StreamUtils.nonClosing(inputMessage.getBody());
            return this.readFromSource(clazz, inputMessage.getHeaders(), new StreamSource(inputStream));
        }
        catch (IOException | HttpMessageConversionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new HttpMessageNotReadableException("Could not unmarshal to [" + clazz + "]: " + ex, ex, inputMessage);
        }
    }

    @Override
    protected final void writeInternal(T t2, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        try {
            this.writeToResult(t2, outputMessage.getHeaders(), new StreamResult(outputMessage.getBody()));
        }
        catch (IOException | HttpMessageConversionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new HttpMessageNotWritableException("Could not marshal [" + t2 + "]: " + ex.getMessage(), ex);
        }
    }

    protected void transform(Source source, Result result) throws TransformerException {
        this.transformerFactory.newTransformer().transform(source, result);
    }

    protected abstract T readFromSource(Class<? extends T> var1, HttpHeaders var2, Source var3) throws Exception;

    protected abstract void writeToResult(T var1, HttpHeaders var2, Result var3) throws Exception;
}

