/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.beans.factory.config;

import java.util.Map;
import java.util.Properties;
import keycloakjar.org.springframework.beans.factory.FactoryBean;
import keycloakjar.org.springframework.beans.factory.InitializingBean;
import keycloakjar.org.springframework.beans.factory.config.YamlProcessor;
import keycloakjar.org.springframework.core.CollectionFactory;
import keycloakjar.org.springframework.lang.Nullable;

public class YamlPropertiesFactoryBean
extends YamlProcessor
implements FactoryBean<Properties>,
InitializingBean {
    private boolean singleton = true;
    @Nullable
    private Properties properties;

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    @Override
    public boolean isSingleton() {
        return this.singleton;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.isSingleton()) {
            this.properties = this.createProperties();
        }
    }

    @Override
    @Nullable
    public Properties getObject() {
        return this.properties != null ? this.properties : this.createProperties();
    }

    @Override
    public Class<?> getObjectType() {
        return Properties.class;
    }

    protected Properties createProperties() {
        Properties result = CollectionFactory.createStringAdaptingProperties();
        this.process((properties, map) -> result.putAll((Map<?, ?>)properties));
        return result;
    }
}

