/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.core.task.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import keycloakjar.org.springframework.core.task.TaskDecorator;
import keycloakjar.org.springframework.util.Assert;

public class CompositeTaskDecorator
implements TaskDecorator {
    private final List<TaskDecorator> taskDecorators;

    public CompositeTaskDecorator(Collection<? extends TaskDecorator> taskDecorators) {
        Assert.notNull(taskDecorators, "TaskDecorators must not be null");
        this.taskDecorators = new ArrayList<TaskDecorator>(taskDecorators);
    }

    @Override
    public Runnable decorate(Runnable runnable) {
        Assert.notNull((Object)runnable, "Runnable must not be null");
        for (TaskDecorator taskDecorator : this.taskDecorators) {
            runnable = taskDecorator.decorate(runnable);
        }
        return runnable;
    }
}

