/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http;

import java.io.Serializable;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;

public final class HttpMethod
implements Comparable<HttpMethod>,
Serializable {
    private static final long serialVersionUID = -70133475680645360L;
    public static final HttpMethod GET = new HttpMethod("GET");
    public static final HttpMethod HEAD = new HttpMethod("HEAD");
    public static final HttpMethod POST = new HttpMethod("POST");
    public static final HttpMethod PUT = new HttpMethod("PUT");
    public static final HttpMethod PATCH = new HttpMethod("PATCH");
    public static final HttpMethod DELETE = new HttpMethod("DELETE");
    public static final HttpMethod OPTIONS = new HttpMethod("OPTIONS");
    public static final HttpMethod TRACE = new HttpMethod("TRACE");
    private static final HttpMethod[] values = new HttpMethod[]{GET, HEAD, POST, PUT, PATCH, DELETE, OPTIONS, TRACE};
    private final String name;

    private HttpMethod(String name) {
        this.name = name;
    }

    public static HttpMethod[] values() {
        HttpMethod[] copy = new HttpMethod[values.length];
        System.arraycopy(values, 0, copy, 0, values.length);
        return copy;
    }

    public static HttpMethod valueOf(String method) {
        Assert.notNull((Object)method, "Method must not be null");
        return switch (method) {
            case "GET" -> GET;
            case "HEAD" -> HEAD;
            case "POST" -> POST;
            case "PUT" -> PUT;
            case "PATCH" -> PATCH;
            case "DELETE" -> DELETE;
            case "OPTIONS" -> OPTIONS;
            case "TRACE" -> TRACE;
            default -> new HttpMethod(method);
        };
    }

    public String name() {
        return this.name;
    }

    public boolean matches(String method) {
        return this.name().equals(method);
    }

    @Override
    public int compareTo(HttpMethod other) {
        return this.name.compareTo(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof HttpMethod)) return false;
        HttpMethod that = (HttpMethod)other;
        if (!this.name.equals(that.name)) return false;
        return true;
    }

    public String toString() {
        return this.name;
    }
}

