/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.server.reactive;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import java.util.function.BiConsumer;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.core.io.buffer.DataBufferFactory;
import keycloakjar.org.springframework.core.io.buffer.DataBufferUtils;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpStatusCode;
import keycloakjar.org.springframework.http.MediaType;
import keycloakjar.org.springframework.http.ResponseCookie;
import keycloakjar.org.springframework.http.server.reactive.AbstractListenerServerHttpResponse;
import keycloakjar.org.springframework.http.server.reactive.AbstractListenerWriteFlushProcessor;
import keycloakjar.org.springframework.http.server.reactive.AbstractListenerWriteProcessor;
import keycloakjar.org.springframework.http.server.reactive.ServletServerHttpRequest;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;

class ServletServerHttpResponse
extends AbstractListenerServerHttpResponse {
    private final HttpServletResponse response;
    private final ServletOutputStream outputStream;
    private final int bufferSize;
    @Nullable
    private volatile ResponseBodyFlushProcessor bodyFlushProcessor;
    @Nullable
    private volatile ResponseBodyProcessor bodyProcessor;
    private volatile boolean flushOnNext;
    private final ServletServerHttpRequest request;
    private final ResponseAsyncListener asyncListener;

    public ServletServerHttpResponse(HttpServletResponse response, AsyncContext asyncContext, DataBufferFactory bufferFactory, int bufferSize, ServletServerHttpRequest request) throws IOException {
        this(new HttpHeaders(), response, asyncContext, bufferFactory, bufferSize, request);
    }

    public ServletServerHttpResponse(HttpHeaders headers, HttpServletResponse response, AsyncContext asyncContext, DataBufferFactory bufferFactory, int bufferSize, ServletServerHttpRequest request) throws IOException {
        super(bufferFactory, headers);
        Assert.notNull((Object)response, "HttpServletResponse must not be null");
        Assert.notNull((Object)bufferFactory, "DataBufferFactory must not be null");
        Assert.isTrue(bufferSize > 0, "Buffer size must be greater than 0");
        this.response = response;
        this.outputStream = response.getOutputStream();
        this.bufferSize = bufferSize;
        this.request = request;
        this.asyncListener = new ResponseAsyncListener();
        response.getOutputStream().setWriteListener((WriteListener)new ResponseBodyWriteListener());
    }

    @Override
    public <T> T getNativeResponse() {
        return (T)this.response;
    }

    @Override
    public HttpStatusCode getStatusCode() {
        HttpStatusCode status = super.getStatusCode();
        return status != null ? status : HttpStatusCode.valueOf(this.response.getStatus());
    }

    @Override
    @Deprecated
    public Integer getRawStatusCode() {
        Integer status = super.getRawStatusCode();
        return status != null ? status.intValue() : this.response.getStatus();
    }

    @Override
    protected void applyStatusCode() {
        HttpStatusCode status = super.getStatusCode();
        if (status != null) {
            this.response.setStatus(status.value());
        }
    }

    @Override
    protected void applyHeaders() {
        this.getHeaders().forEach((BiConsumer<? super String, ? super List<String>>)((BiConsumer<String, List>)(headerName, headerValues) -> {
            for (String headerValue : headerValues) {
                this.response.addHeader(headerName, headerValue);
            }
        }));
        this.adaptHeaders(false);
    }

    protected void adaptHeaders(boolean removeAdaptedHeaders) {
        long contentLength;
        Charset charset;
        MediaType contentType = null;
        try {
            contentType = this.getHeaders().getContentType();
        }
        catch (Exception ex) {
            String rawContentType = this.getHeaders().getFirst("Content-Type");
            this.response.setContentType(rawContentType);
        }
        if (this.response.getContentType() == null && contentType != null) {
            this.response.setContentType(contentType.toString());
        }
        Charset charset2 = charset = contentType != null ? contentType.getCharset() : null;
        if (this.response.getCharacterEncoding() == null && charset != null) {
            this.response.setCharacterEncoding(charset.name());
        }
        if ((contentLength = this.getHeaders().getContentLength()) != -1L) {
            this.response.setContentLengthLong(contentLength);
        }
        if (removeAdaptedHeaders) {
            this.getHeaders().remove("Content-Type");
            this.getHeaders().remove("Content-Length");
        }
    }

    @Override
    protected void applyCookies() {
        for (String name : this.getCookies().keySet()) {
            for (ResponseCookie httpCookie : (List)this.getCookies().get(name)) {
                Cookie cookie = new Cookie(name, httpCookie.getValue());
                if (!httpCookie.getMaxAge().isNegative()) {
                    cookie.setMaxAge((int)httpCookie.getMaxAge().getSeconds());
                }
                if (httpCookie.getDomain() != null) {
                    cookie.setDomain(httpCookie.getDomain());
                }
                if (httpCookie.getPath() != null) {
                    cookie.setPath(httpCookie.getPath());
                }
                if (httpCookie.getSameSite() != null) {
                    cookie.setAttribute("SameSite", httpCookie.getSameSite());
                }
                cookie.setSecure(httpCookie.isSecure());
                cookie.setHttpOnly(httpCookie.isHttpOnly());
                this.response.addCookie(cookie);
            }
        }
    }

    AsyncListener getAsyncListener() {
        return this.asyncListener;
    }

    @Override
    protected Processor<? super Publisher<? extends DataBuffer>, Void> createBodyFlushProcessor() {
        ResponseBodyFlushProcessor processor;
        this.bodyFlushProcessor = processor = new ResponseBodyFlushProcessor();
        return processor;
    }

    protected final ServletOutputStream getOutputStream() {
        return this.outputStream;
    }

    protected int writeToOutputStream(DataBuffer dataBuffer) throws IOException {
        int bytesRead;
        ServletOutputStream outputStream = this.outputStream;
        InputStream input = dataBuffer.asInputStream();
        int bytesWritten = 0;
        byte[] buffer = new byte[this.bufferSize];
        while (outputStream.isReady() && (bytesRead = input.read(buffer)) != -1) {
            outputStream.write(buffer, 0, bytesRead);
            bytesWritten += bytesRead;
        }
        return bytesWritten;
    }

    private void flush() throws IOException {
        ServletOutputStream outputStream = this.outputStream;
        if (outputStream.isReady()) {
            try {
                outputStream.flush();
                this.flushOnNext = false;
            }
            catch (IOException ex) {
                this.flushOnNext = true;
                throw ex;
            }
        } else {
            this.flushOnNext = true;
        }
    }

    private boolean isWritePossible() {
        return this.outputStream.isReady();
    }

    private final class ResponseAsyncListener
    implements AsyncListener {
        private ResponseAsyncListener() {
        }

        public void onStartAsync(AsyncEvent event) {
        }

        public void onTimeout(AsyncEvent event) {
            Throwable ex = event.getThrowable();
            ex = ex != null ? ex : new IllegalStateException("Async operation timeout.");
            this.handleError(ex);
        }

        public void onError(AsyncEvent event) {
            this.handleError(event.getThrowable());
        }

        public void handleError(Throwable ex) {
            ResponseBodyFlushProcessor flushProcessor = ServletServerHttpResponse.this.bodyFlushProcessor;
            ResponseBodyProcessor processor = ServletServerHttpResponse.this.bodyProcessor;
            if (flushProcessor != null) {
                flushProcessor.cancel();
                if (processor != null) {
                    processor.cancel();
                    processor.onError(ex);
                }
                flushProcessor.onError(ex);
            }
        }

        public void onComplete(AsyncEvent event) {
            ResponseBodyFlushProcessor flushProcessor = ServletServerHttpResponse.this.bodyFlushProcessor;
            ResponseBodyProcessor processor = ServletServerHttpResponse.this.bodyProcessor;
            if (flushProcessor != null) {
                flushProcessor.cancel();
                if (processor != null) {
                    processor.cancel();
                    processor.onComplete();
                }
                flushProcessor.onComplete();
            }
        }
    }

    private class ResponseBodyWriteListener
    implements WriteListener {
        private ResponseBodyWriteListener() {
        }

        public void onWritePossible() {
            ResponseBodyProcessor processor = ServletServerHttpResponse.this.bodyProcessor;
            if (processor != null) {
                processor.onWritePossible();
            } else {
                ResponseBodyFlushProcessor flushProcessor = ServletServerHttpResponse.this.bodyFlushProcessor;
                if (flushProcessor != null) {
                    flushProcessor.onFlushPossible();
                }
            }
        }

        public void onError(Throwable ex) {
            ServletServerHttpResponse.this.asyncListener.handleError(ex);
        }
    }

    private class ResponseBodyFlushProcessor
    extends AbstractListenerWriteFlushProcessor<DataBuffer> {
        public ResponseBodyFlushProcessor() {
            super(ServletServerHttpResponse.this.request.getLogPrefix());
        }

        @Override
        protected Processor<? super DataBuffer, Void> createWriteProcessor() {
            ResponseBodyProcessor processor;
            ServletServerHttpResponse.this.bodyProcessor = processor = new ResponseBodyProcessor();
            return processor;
        }

        @Override
        protected void flush() throws IOException {
            if (rsWriteFlushLogger.isTraceEnabled()) {
                rsWriteFlushLogger.trace(this.getLogPrefix() + "flushing");
            }
            ServletServerHttpResponse.this.flush();
        }

        @Override
        protected boolean isWritePossible() {
            return ServletServerHttpResponse.this.isWritePossible();
        }

        @Override
        protected boolean isFlushPending() {
            return ServletServerHttpResponse.this.flushOnNext;
        }
    }

    private class ResponseBodyProcessor
    extends AbstractListenerWriteProcessor<DataBuffer> {
        public ResponseBodyProcessor() {
            super(ServletServerHttpResponse.this.request.getLogPrefix());
        }

        @Override
        protected boolean isWritePossible() {
            return ServletServerHttpResponse.this.isWritePossible();
        }

        @Override
        protected boolean isDataEmpty(DataBuffer dataBuffer) {
            return dataBuffer.readableByteCount() == 0;
        }

        @Override
        protected boolean write(DataBuffer dataBuffer) throws IOException {
            if (ServletServerHttpResponse.this.flushOnNext) {
                if (rsWriteLogger.isTraceEnabled()) {
                    rsWriteLogger.trace(this.getLogPrefix() + "flushing");
                }
                ServletServerHttpResponse.this.flush();
            }
            boolean ready = ServletServerHttpResponse.this.isWritePossible();
            int remaining = dataBuffer.readableByteCount();
            if (ready && remaining > 0) {
                int written = ServletServerHttpResponse.this.writeToOutputStream(dataBuffer);
                if (rsWriteLogger.isTraceEnabled()) {
                    rsWriteLogger.trace(this.getLogPrefix() + "Wrote " + written + " of " + remaining + " bytes");
                }
                if (written == remaining) {
                    DataBufferUtils.release(dataBuffer);
                    return true;
                }
            } else if (rsWriteLogger.isTraceEnabled()) {
                rsWriteLogger.trace(this.getLogPrefix() + "ready: " + ready + ", remaining: " + remaining);
            }
            return false;
        }

        @Override
        protected void writingComplete() {
            ServletServerHttpResponse.this.bodyProcessor = null;
        }

        @Override
        protected void discardData(DataBuffer dataBuffer) {
            DataBufferUtils.release(dataBuffer);
        }
    }
}

