/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.bind.support;

import jakarta.validation.Validator;
import java.lang.annotation.Annotation;
import keycloakjar.org.springframework.core.MethodParameter;
import keycloakjar.org.springframework.core.ResolvableType;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.validation.DataBinder;
import keycloakjar.org.springframework.validation.SmartValidator;
import keycloakjar.org.springframework.web.bind.WebDataBinder;
import keycloakjar.org.springframework.web.bind.support.BindParamNameResolver;
import keycloakjar.org.springframework.web.bind.support.WebBindingInitializer;
import keycloakjar.org.springframework.web.bind.support.WebDataBinderFactory;
import keycloakjar.org.springframework.web.bind.support.WebRequestDataBinder;
import keycloakjar.org.springframework.web.context.request.NativeWebRequest;

public class DefaultDataBinderFactory
implements WebDataBinderFactory {
    @Nullable
    private final WebBindingInitializer initializer;
    private boolean methodValidationApplicable;

    public DefaultDataBinderFactory(@Nullable WebBindingInitializer initializer) {
        this.initializer = initializer;
    }

    public void setMethodValidationApplicable(boolean methodValidationApplicable) {
        this.methodValidationApplicable = methodValidationApplicable;
    }

    @Override
    public final WebDataBinder createBinder(NativeWebRequest webRequest, @Nullable Object target, String objectName) throws Exception {
        return this.createBinderInternal(webRequest, target, objectName, null);
    }

    @Override
    public final WebDataBinder createBinder(NativeWebRequest webRequest, @Nullable Object target, String objectName, ResolvableType type) throws Exception {
        return this.createBinderInternal(webRequest, target, objectName, type);
    }

    private WebDataBinder createBinderInternal(NativeWebRequest webRequest, @Nullable Object target, String objectName, @Nullable ResolvableType type) throws Exception {
        Object object;
        WebDataBinder dataBinder = this.createBinderInstance(target, objectName, webRequest);
        dataBinder.setNameResolver(new BindParamNameResolver());
        if (target == null && type != null) {
            dataBinder.setTargetType(type);
        }
        if (this.initializer != null) {
            this.initializer.initBinder(dataBinder);
        }
        this.initBinder(dataBinder, webRequest);
        if (this.methodValidationApplicable && type != null && (object = type.getSource()) instanceof MethodParameter) {
            MethodParameter parameter = (MethodParameter)object;
            MethodValidationInitializer.initBinder(dataBinder, parameter);
        }
        return dataBinder;
    }

    protected WebDataBinder createBinderInstance(@Nullable Object target, String objectName, NativeWebRequest webRequest) throws Exception {
        return new WebRequestDataBinder(target, objectName);
    }

    protected void initBinder(WebDataBinder dataBinder, NativeWebRequest webRequest) throws Exception {
    }

    private static class MethodValidationInitializer {
        private MethodValidationInitializer() {
        }

        public static void initBinder(DataBinder binder, MethodParameter parameter) {
            for (Annotation annotation : parameter.getParameterAnnotations()) {
                if (!annotation.annotationType().getName().equals("jakarta.validation.Valid")) continue;
                binder.setExcludedValidators(v -> {
                    SmartValidator sv;
                    return v instanceof Validator || v instanceof SmartValidator && (sv = (SmartValidator)v).unwrap(Validator.class) != null;
                });
            }
        }
    }
}

