/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.multipart;

import keycloakjar.org.springframework.http.HttpStatus;
import keycloakjar.org.springframework.http.HttpStatusCode;
import keycloakjar.org.springframework.http.ProblemDetail;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.web.ErrorResponse;
import keycloakjar.org.springframework.web.multipart.MultipartException;

public class MaxUploadSizeExceededException
extends MultipartException
implements ErrorResponse {
    private final ProblemDetail body = ProblemDetail.forStatusAndDetail(HttpStatus.PAYLOAD_TOO_LARGE, "Maximum upload size exceeded");
    private final long maxUploadSize;

    public MaxUploadSizeExceededException(long maxUploadSize) {
        this(maxUploadSize, null);
    }

    public MaxUploadSizeExceededException(long maxUploadSize, @Nullable Throwable ex) {
        super("Maximum upload size " + (String)(maxUploadSize >= 0L ? "of " + maxUploadSize + " bytes " : "") + "exceeded", ex);
        this.maxUploadSize = maxUploadSize;
    }

    public long getMaxUploadSize() {
        return this.maxUploadSize;
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return HttpStatus.PAYLOAD_TOO_LARGE;
    }

    @Override
    public ProblemDetail getBody() {
        return this.body;
    }
}

