/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.cglib.transform.impl;

import java.lang.reflect.Constructor;
import keycloakjar.org.springframework.asm.Type;
import keycloakjar.org.springframework.cglib.core.Block;
import keycloakjar.org.springframework.cglib.core.CodeEmitter;
import keycloakjar.org.springframework.cglib.core.Constants;
import keycloakjar.org.springframework.cglib.core.EmitUtils;
import keycloakjar.org.springframework.cglib.core.Signature;
import keycloakjar.org.springframework.cglib.core.TypeUtils;
import keycloakjar.org.springframework.cglib.transform.ClassEmitterTransformer;

public class UndeclaredThrowableTransformer
extends ClassEmitterTransformer {
    private final Type wrapper;

    public UndeclaredThrowableTransformer(Class wrapper) {
        Constructor<?>[] cstructs;
        this.wrapper = Type.getType(wrapper);
        boolean found = false;
        for (Constructor<?> cstruct : cstructs = wrapper.getConstructors()) {
            Class<?>[] types = cstruct.getParameterTypes();
            if (types.length != 1 || !types[0].equals(Throwable.class)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException(wrapper + " does not have a single-arg constructor that takes a Throwable");
        }
    }

    @Override
    public CodeEmitter begin_method(int access, Signature sig, final Type[] exceptions) {
        CodeEmitter e = super.begin_method(access, sig, exceptions);
        if (TypeUtils.isAbstract(access) || sig.equals(Constants.SIG_STATIC)) {
            return e;
        }
        return new CodeEmitter(e){
            private Block handler;
            {
                super(wrap);
                this.handler = this.begin_block();
            }

            @Override
            public void visitMaxs(int maxStack, int maxLocals) {
                this.handler.end();
                EmitUtils.wrap_undeclared_throwable(this, this.handler, exceptions, UndeclaredThrowableTransformer.this.wrapper);
                super.visitMaxs(maxStack, maxLocals);
            }
        };
    }
}

