/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.apache.hc.core5.http.impl.io;

import keycloakjar.org.apache.hc.core5.annotation.Contract;
import keycloakjar.org.apache.hc.core5.annotation.ThreadingBehavior;
import keycloakjar.org.apache.hc.core5.http.ClassicHttpResponse;
import keycloakjar.org.apache.hc.core5.http.HttpResponseFactory;
import keycloakjar.org.apache.hc.core5.http.ReasonPhraseCatalog;
import keycloakjar.org.apache.hc.core5.http.impl.EnglishReasonPhraseCatalog;
import keycloakjar.org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import keycloakjar.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultClassicHttpResponseFactory
implements HttpResponseFactory<ClassicHttpResponse> {
    public static final DefaultClassicHttpResponseFactory INSTANCE = new DefaultClassicHttpResponseFactory();
    private final ReasonPhraseCatalog reasonCatalog;

    public DefaultClassicHttpResponseFactory(ReasonPhraseCatalog catalog) {
        this.reasonCatalog = Args.notNull(catalog, "Reason phrase catalog");
    }

    public DefaultClassicHttpResponseFactory() {
        this(EnglishReasonPhraseCatalog.INSTANCE);
    }

    @Override
    public ClassicHttpResponse newHttpResponse(int status, String reasonPhrase) {
        return new BasicClassicHttpResponse(status, reasonPhrase);
    }

    @Override
    public ClassicHttpResponse newHttpResponse(int status) {
        return new BasicClassicHttpResponse(status, this.reasonCatalog, null);
    }
}

