/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.aot.generate;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import keycloakjar.org.springframework.aot.generate.GeneratedMethod;
import keycloakjar.org.springframework.aot.generate.MethodName;
import keycloakjar.org.springframework.javapoet.ClassName;
import keycloakjar.org.springframework.javapoet.MethodSpec;
import keycloakjar.org.springframework.util.Assert;

public class GeneratedMethods {
    private final ClassName className;
    private final Function<MethodName, String> methodNameGenerator;
    private final MethodName prefix;
    private final List<GeneratedMethod> generatedMethods;

    GeneratedMethods(ClassName className, Function<MethodName, String> methodNameGenerator) {
        Assert.notNull((Object)className, "'className' must not be null");
        Assert.notNull(methodNameGenerator, "'methodNameGenerator' must not be null");
        this.className = className;
        this.methodNameGenerator = methodNameGenerator;
        this.prefix = MethodName.NONE;
        this.generatedMethods = new ArrayList<GeneratedMethod>();
    }

    private GeneratedMethods(ClassName className, Function<MethodName, String> methodNameGenerator, MethodName prefix, List<GeneratedMethod> generatedMethods) {
        this.className = className;
        this.methodNameGenerator = methodNameGenerator;
        this.prefix = prefix;
        this.generatedMethods = generatedMethods;
    }

    public GeneratedMethod add(String suggestedName, Consumer<MethodSpec.Builder> method) {
        Assert.notNull((Object)suggestedName, "'suggestedName' must not be null");
        return this.add(new String[]{suggestedName}, method);
    }

    public GeneratedMethod add(String[] suggestedNameParts, Consumer<MethodSpec.Builder> method) {
        Assert.notNull((Object)suggestedNameParts, "'suggestedNameParts' must not be null");
        Assert.notNull(method, "'method' must not be null");
        String generatedName = this.methodNameGenerator.apply(this.prefix.and(suggestedNameParts));
        GeneratedMethod generatedMethod = new GeneratedMethod(this.className, generatedName, method);
        this.generatedMethods.add(generatedMethod);
        return generatedMethod;
    }

    public GeneratedMethods withPrefix(String prefix) {
        Assert.notNull((Object)prefix, "'prefix' must not be null");
        return new GeneratedMethods(this.className, this.methodNameGenerator, this.prefix.and(prefix), this.generatedMethods);
    }

    void doWithMethodSpecs(Consumer<MethodSpec> action) {
        this.stream().map(GeneratedMethod::getMethodSpec).forEach(action);
    }

    Stream<GeneratedMethod> stream() {
        return this.generatedMethods.stream();
    }
}

