/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.aot.hint;

import java.util.Arrays;
import java.util.List;
import keycloakjar.org.springframework.aot.hint.ReflectionTypeReference;
import keycloakjar.org.springframework.aot.hint.SimpleTypeReference;
import keycloakjar.org.springframework.lang.Nullable;

public interface TypeReference
extends Comparable<TypeReference> {
    public String getName();

    public String getCanonicalName();

    public String getPackageName();

    public String getSimpleName();

    @Nullable
    public TypeReference getEnclosingType();

    public static TypeReference of(Class<?> type) {
        return ReflectionTypeReference.of(type);
    }

    public static TypeReference of(String className) {
        return SimpleTypeReference.of(className);
    }

    public static List<TypeReference> listOf(Class<?> ... types) {
        return Arrays.stream(types).map(TypeReference::of).toList();
    }
}

