/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.beans.factory.aot;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import keycloakjar.org.springframework.beans.BeanInstantiationException;
import keycloakjar.org.springframework.beans.BeanUtils;
import keycloakjar.org.springframework.beans.BeansException;
import keycloakjar.org.springframework.beans.TypeConverter;
import keycloakjar.org.springframework.beans.factory.BeanFactory;
import keycloakjar.org.springframework.beans.factory.InjectionPoint;
import keycloakjar.org.springframework.beans.factory.UnsatisfiedDependencyException;
import keycloakjar.org.springframework.beans.factory.aot.AutowiredArguments;
import keycloakjar.org.springframework.beans.factory.aot.AutowiredElementResolver;
import keycloakjar.org.springframework.beans.factory.config.ConfigurableBeanFactory;
import keycloakjar.org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import keycloakjar.org.springframework.beans.factory.config.ConstructorArgumentValues;
import keycloakjar.org.springframework.beans.factory.config.DependencyDescriptor;
import keycloakjar.org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import keycloakjar.org.springframework.beans.factory.support.BeanDefinitionValueResolver;
import keycloakjar.org.springframework.beans.factory.support.InstanceSupplier;
import keycloakjar.org.springframework.beans.factory.support.RegisteredBean;
import keycloakjar.org.springframework.beans.factory.support.RootBeanDefinition;
import keycloakjar.org.springframework.beans.factory.support.SimpleInstantiationStrategy;
import keycloakjar.org.springframework.core.MethodParameter;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.ClassUtils;
import keycloakjar.org.springframework.util.ObjectUtils;
import keycloakjar.org.springframework.util.ReflectionUtils;
import keycloakjar.org.springframework.util.function.ThrowingBiFunction;
import keycloakjar.org.springframework.util.function.ThrowingFunction;
import keycloakjar.org.springframework.util.function.ThrowingSupplier;

public final class BeanInstanceSupplier<T>
extends AutowiredElementResolver
implements InstanceSupplier<T> {
    private final ExecutableLookup lookup;
    @Nullable
    private final ThrowingBiFunction<RegisteredBean, AutowiredArguments, T> generator;
    @Nullable
    private final String[] shortcuts;

    private BeanInstanceSupplier(ExecutableLookup lookup, @Nullable ThrowingBiFunction<RegisteredBean, AutowiredArguments, T> generator, @Nullable String[] shortcuts) {
        this.lookup = lookup;
        this.generator = generator;
        this.shortcuts = shortcuts;
    }

    public static <T> BeanInstanceSupplier<T> forConstructor(Class<?> ... parameterTypes) {
        Assert.notNull(parameterTypes, "'parameterTypes' must not be null");
        Assert.noNullElements((Object[])parameterTypes, "'parameterTypes' must not contain null elements");
        return new BeanInstanceSupplier<T>(new ConstructorLookup(parameterTypes), null, null);
    }

    public static <T> BeanInstanceSupplier<T> forFactoryMethod(Class<?> declaringClass, String methodName, Class<?> ... parameterTypes) {
        Assert.notNull(declaringClass, "'declaringClass' must not be null");
        Assert.hasText(methodName, "'methodName' must not be empty");
        Assert.notNull(parameterTypes, "'parameterTypes' must not be null");
        Assert.noNullElements((Object[])parameterTypes, "'parameterTypes' must not contain null elements");
        return new BeanInstanceSupplier<T>(new FactoryMethodLookup(declaringClass, methodName, parameterTypes), null, null);
    }

    ExecutableLookup getLookup() {
        return this.lookup;
    }

    public BeanInstanceSupplier<T> withGenerator(ThrowingBiFunction<RegisteredBean, AutowiredArguments, T> generator) {
        Assert.notNull(generator, "'generator' must not be null");
        return new BeanInstanceSupplier<T>(this.lookup, generator, this.shortcuts);
    }

    public BeanInstanceSupplier<T> withGenerator(ThrowingFunction<RegisteredBean, T> generator) {
        Assert.notNull(generator, "'generator' must not be null");
        return new BeanInstanceSupplier<Object>(this.lookup, (registeredBean, args) -> generator.apply((RegisteredBean)registeredBean), this.shortcuts);
    }

    @Deprecated(since="6.0.11", forRemoval=true)
    public BeanInstanceSupplier<T> withGenerator(ThrowingSupplier<T> generator) {
        Assert.notNull(generator, "'generator' must not be null");
        return new BeanInstanceSupplier<Object>(this.lookup, (registeredBean, args) -> generator.get(), this.shortcuts);
    }

    public BeanInstanceSupplier<T> withShortcuts(String ... beanNames) {
        return new BeanInstanceSupplier<T>(this.lookup, this.generator, beanNames);
    }

    @Override
    public T get(RegisteredBean registeredBean) throws Exception {
        Assert.notNull((Object)registeredBean, "'registeredBean' must not be null");
        Executable executable = this.lookup.get(registeredBean);
        AutowiredArguments arguments = this.resolveArguments(registeredBean, executable);
        if (this.generator != null) {
            return (T)this.invokeBeanSupplier(executable, () -> this.generator.apply(registeredBean, arguments));
        }
        return (T)this.invokeBeanSupplier(executable, () -> this.instantiate((ConfigurableBeanFactory)registeredBean.getBeanFactory(), executable, arguments.toArray()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T invokeBeanSupplier(Executable executable, ThrowingSupplier<T> beanSupplier) {
        if (!(executable instanceof Method)) {
            return beanSupplier.get();
        }
        Method method = (Method)executable;
        Method priorInvokedFactoryMethod = SimpleInstantiationStrategy.getCurrentlyInvokedFactoryMethod();
        try {
            SimpleInstantiationStrategy.setCurrentlyInvokedFactoryMethod(method);
            T t2 = beanSupplier.get();
            return t2;
        }
        finally {
            SimpleInstantiationStrategy.setCurrentlyInvokedFactoryMethod(priorInvokedFactoryMethod);
        }
    }

    @Override
    @Nullable
    public Method getFactoryMethod() {
        ExecutableLookup executableLookup = this.lookup;
        if (executableLookup instanceof FactoryMethodLookup) {
            FactoryMethodLookup factoryMethodLookup = (FactoryMethodLookup)executableLookup;
            return factoryMethodLookup.get();
        }
        return null;
    }

    AutowiredArguments resolveArguments(RegisteredBean registeredBean) {
        Assert.notNull((Object)registeredBean, "'registeredBean' must not be null");
        return this.resolveArguments(registeredBean, this.lookup.get(registeredBean));
    }

    private AutowiredArguments resolveArguments(RegisteredBean registeredBean, Executable executable) {
        Constructor constructor;
        Assert.isInstanceOf(AbstractAutowireCapableBeanFactory.class, registeredBean.getBeanFactory());
        int startIndex = executable instanceof Constructor && ClassUtils.isInnerClass((constructor = (Constructor)executable).getDeclaringClass()) ? 1 : 0;
        int parameterCount = executable.getParameterCount();
        Object[] resolved = new Object[parameterCount - startIndex];
        Assert.isTrue(this.shortcuts == null || this.shortcuts.length == resolved.length, () -> "'shortcuts' must contain " + resolved.length + " elements");
        ConstructorArgumentValues.ValueHolder[] argumentValues = this.resolveArgumentValues(registeredBean, executable);
        LinkedHashSet<String> autowiredBeanNames = new LinkedHashSet<String>(resolved.length * 2);
        for (int i = startIndex; i < parameterCount; ++i) {
            String shortcut;
            MethodParameter parameter = this.getMethodParameter(executable, i);
            DependencyDescriptor descriptor = new DependencyDescriptor(parameter, true);
            String string = shortcut = this.shortcuts != null ? this.shortcuts[i - startIndex] : null;
            if (shortcut != null) {
                descriptor = new AutowiredElementResolver.ShortcutDependencyDescriptor(descriptor, shortcut);
            }
            ConstructorArgumentValues.ValueHolder argumentValue = argumentValues[i];
            resolved[i - startIndex] = this.resolveAutowiredArgument(registeredBean, descriptor, argumentValue, autowiredBeanNames);
        }
        this.registerDependentBeans(registeredBean.getBeanFactory(), registeredBean.getBeanName(), autowiredBeanNames);
        return AutowiredArguments.of(resolved);
    }

    private MethodParameter getMethodParameter(Executable executable, int index) {
        if (executable instanceof Constructor) {
            Constructor constructor = (Constructor)executable;
            return new MethodParameter(constructor, index);
        }
        if (executable instanceof Method) {
            Method method = (Method)executable;
            return new MethodParameter(method, index);
        }
        throw new IllegalStateException("Unsupported executable: " + executable.getClass().getName());
    }

    private ConstructorArgumentValues.ValueHolder[] resolveArgumentValues(RegisteredBean registeredBean, Executable executable) {
        ConfigurableListableBeanFactory configurableListableBeanFactory;
        Parameter[] parameters = executable.getParameters();
        ConstructorArgumentValues.ValueHolder[] resolved = new ConstructorArgumentValues.ValueHolder[parameters.length];
        RootBeanDefinition beanDefinition = registeredBean.getMergedBeanDefinition();
        if (beanDefinition.hasConstructorArgumentValues() && (configurableListableBeanFactory = registeredBean.getBeanFactory()) instanceof AbstractAutowireCapableBeanFactory) {
            AbstractAutowireCapableBeanFactory beanFactory = (AbstractAutowireCapableBeanFactory)((Object)configurableListableBeanFactory);
            BeanDefinitionValueResolver valueResolver = new BeanDefinitionValueResolver(beanFactory, registeredBean.getBeanName(), beanDefinition, beanFactory.getTypeConverter());
            ConstructorArgumentValues values = this.resolveConstructorArguments(valueResolver, beanDefinition.getConstructorArgumentValues());
            HashSet<ConstructorArgumentValues.ValueHolder> usedValueHolders = new HashSet<ConstructorArgumentValues.ValueHolder>(parameters.length);
            for (int i = 0; i < parameters.length; ++i) {
                String parameterName;
                Class<?> parameterType = parameters[i].getType();
                ConstructorArgumentValues.ValueHolder valueHolder = values.getArgumentValue(i, parameterType, parameterName = parameters[i].isNamePresent() ? parameters[i].getName() : null, usedValueHolders);
                if (valueHolder == null) continue;
                resolved[i] = valueHolder;
                usedValueHolders.add(valueHolder);
            }
        }
        return resolved;
    }

    private ConstructorArgumentValues resolveConstructorArguments(BeanDefinitionValueResolver valueResolver, ConstructorArgumentValues constructorArguments) {
        ConstructorArgumentValues resolvedConstructorArguments = new ConstructorArgumentValues();
        for (Map.Entry<Integer, ConstructorArgumentValues.ValueHolder> entry : constructorArguments.getIndexedArgumentValues().entrySet()) {
            resolvedConstructorArguments.addIndexedArgumentValue((int)entry.getKey(), this.resolveArgumentValue(valueResolver, entry.getValue()));
        }
        for (ConstructorArgumentValues.ValueHolder valueHolder : constructorArguments.getGenericArgumentValues()) {
            resolvedConstructorArguments.addGenericArgumentValue(this.resolveArgumentValue(valueResolver, valueHolder));
        }
        return resolvedConstructorArguments;
    }

    private ConstructorArgumentValues.ValueHolder resolveArgumentValue(BeanDefinitionValueResolver resolver, ConstructorArgumentValues.ValueHolder valueHolder) {
        if (valueHolder.isConverted()) {
            return valueHolder;
        }
        Object value = resolver.resolveValueIfNecessary("constructor argument", valueHolder.getValue());
        ConstructorArgumentValues.ValueHolder resolvedHolder = new ConstructorArgumentValues.ValueHolder(value, valueHolder.getType(), valueHolder.getName());
        resolvedHolder.setSource(valueHolder);
        return resolvedHolder;
    }

    @Nullable
    private Object resolveAutowiredArgument(RegisteredBean registeredBean, DependencyDescriptor descriptor, @Nullable ConstructorArgumentValues.ValueHolder argumentValue, Set<String> autowiredBeanNames) {
        TypeConverter typeConverter = registeredBean.getBeanFactory().getTypeConverter();
        if (argumentValue != null) {
            return argumentValue.isConverted() ? argumentValue.getConvertedValue() : typeConverter.convertIfNecessary(argumentValue.getValue(), descriptor.getDependencyType(), descriptor.getMethodParameter());
        }
        try {
            return registeredBean.resolveAutowiredArgument(descriptor, typeConverter, autowiredBeanNames);
        }
        catch (BeansException ex) {
            throw new UnsatisfiedDependencyException(null, registeredBean.getBeanName(), (InjectionPoint)descriptor, ex);
        }
    }

    private T instantiate(ConfigurableBeanFactory beanFactory, Executable executable, Object[] args) {
        if (executable instanceof Constructor) {
            Constructor constructor = (Constructor)executable;
            try {
                return (T)this.instantiate(constructor, args);
            }
            catch (Exception ex) {
                throw new BeanInstantiationException(constructor, ex.getMessage(), (Throwable)ex);
            }
        }
        if (executable instanceof Method) {
            Method method = (Method)executable;
            try {
                return (T)this.instantiate(beanFactory, method, args);
            }
            catch (Exception ex) {
                throw new BeanInstantiationException(method, ex.getMessage(), (Throwable)ex);
            }
        }
        throw new IllegalStateException("Unsupported executable " + executable.getClass().getName());
    }

    private Object instantiate(Constructor<?> constructor, Object[] args) throws Exception {
        Class<?> declaringClass = constructor.getDeclaringClass();
        if (ClassUtils.isInnerClass(declaringClass)) {
            Object enclosingInstance = this.createInstance(declaringClass.getEnclosingClass());
            args = ObjectUtils.addObjectToArray(args, enclosingInstance, 0);
        }
        return BeanUtils.instantiateClass(constructor, args);
    }

    private Object instantiate(ConfigurableBeanFactory beanFactory, Method method, Object[] args) throws Exception {
        Object target = this.getFactoryMethodTarget(beanFactory, method);
        ReflectionUtils.makeAccessible(method);
        return method.invoke(target, args);
    }

    @Nullable
    private Object getFactoryMethodTarget(BeanFactory beanFactory, Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            return null;
        }
        Class<?> declaringClass = method.getDeclaringClass();
        return beanFactory.getBean(declaringClass);
    }

    private Object createInstance(Class<?> clazz) throws Exception {
        if (!ClassUtils.isInnerClass(clazz)) {
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            ReflectionUtils.makeAccessible(constructor);
            return constructor.newInstance(new Object[0]);
        }
        Class<?> enclosingClass = clazz.getEnclosingClass();
        Constructor<?> constructor = clazz.getDeclaredConstructor(enclosingClass);
        return constructor.newInstance(this.createInstance(enclosingClass));
    }

    private static String toCommaSeparatedNames(Class<?> ... parameterTypes) {
        return Arrays.stream(parameterTypes).map(Class::getName).collect(Collectors.joining(", "));
    }

    static abstract class ExecutableLookup {
        ExecutableLookup() {
        }

        abstract Executable get(RegisteredBean var1);
    }

    private static class ConstructorLookup
    extends ExecutableLookup {
        private final Class<?>[] parameterTypes;

        ConstructorLookup(Class<?>[] parameterTypes) {
            this.parameterTypes = parameterTypes;
        }

        @Override
        public Executable get(RegisteredBean registeredBean) {
            Class<?> beanClass = registeredBean.getBeanClass();
            try {
                Class<?>[] actualParameterTypes = !ClassUtils.isInnerClass(beanClass) ? this.parameterTypes : ObjectUtils.addObjectToArray(this.parameterTypes, beanClass.getEnclosingClass(), 0);
                return beanClass.getDeclaredConstructor(actualParameterTypes);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalArgumentException("%s cannot be found on %s".formatted(this, beanClass.getName()), ex);
            }
        }

        public String toString() {
            return "Constructor with parameter types [%s]".formatted(BeanInstanceSupplier.toCommaSeparatedNames(this.parameterTypes));
        }
    }

    private static class FactoryMethodLookup
    extends ExecutableLookup {
        private final Class<?> declaringClass;
        private final String methodName;
        private final Class<?>[] parameterTypes;

        FactoryMethodLookup(Class<?> declaringClass, String methodName, Class<?>[] parameterTypes) {
            this.declaringClass = declaringClass;
            this.methodName = methodName;
            this.parameterTypes = parameterTypes;
        }

        @Override
        public Executable get(RegisteredBean registeredBean) {
            return this.get();
        }

        Method get() {
            Method method = ReflectionUtils.findMethod(this.declaringClass, this.methodName, this.parameterTypes);
            Assert.notNull((Object)method, () -> "%s cannot be found".formatted(this));
            return method;
        }

        public String toString() {
            return "Factory method '%s' with parameter types [%s] declared on %s".formatted(this.methodName, BeanInstanceSupplier.toCommaSeparatedNames(this.parameterTypes), this.declaringClass);
        }
    }
}

