/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.beans.factory.support;

import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import keycloakjar.org.springframework.beans.factory.support.MethodOverride;
import keycloakjar.org.springframework.lang.Nullable;

public class MethodOverrides {
    private final Set<MethodOverride> overrides = new CopyOnWriteArraySet<MethodOverride>();

    public MethodOverrides() {
    }

    public MethodOverrides(MethodOverrides other) {
        this.addOverrides(other);
    }

    public void addOverrides(@Nullable MethodOverrides other) {
        if (other != null) {
            this.overrides.addAll(other.overrides);
        }
    }

    public void addOverride(MethodOverride override) {
        this.overrides.add(override);
    }

    public Set<MethodOverride> getOverrides() {
        return this.overrides;
    }

    public boolean isEmpty() {
        return this.overrides.isEmpty();
    }

    @Nullable
    public MethodOverride getOverride(Method method) {
        MethodOverride match = null;
        for (MethodOverride candidate : this.overrides) {
            if (!candidate.matches(method)) continue;
            match = candidate;
        }
        return match;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof MethodOverrides)) return false;
        MethodOverrides that = (MethodOverrides)other;
        if (!this.overrides.equals(that.overrides)) return false;
        return true;
    }

    public int hashCode() {
        return this.overrides.hashCode();
    }
}

